/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import org.apache.commons.validator.routines.EmailValidator;

public class HyperlinkUtil {
    private static final String SCHEME_URL = "://";

    private HyperlinkUtil() {
    }

    static String hyperlink(String text) {
        if (text == null) {
            text = "";
        }
        StringBuffer sb = new StringBuffer((int)((double)text.length() * 1.1));
        sb.append(text);
        HyperlinkUtil.linkEmail(sb);
        HyperlinkUtil.linkURL(sb);
        return sb.toString();
    }

    private static int getStartUrl(StringBuffer str, int startIndex) {
        int schemeIndex = HyperlinkUtil.getSchemeIndex(str, startIndex);
        int wwwIndex = str.indexOf("www.", startIndex + 1);
        if (schemeIndex == -1 && wwwIndex == -1) {
            return -1;
        }
        if (schemeIndex == -1) {
            return wwwIndex;
        }
        if (wwwIndex == -1) {
            return schemeIndex;
        }
        return Math.min(schemeIndex, wwwIndex);
    }

    private static int getSchemeIndex(StringBuffer str, int startIndex) {
        char currentChar;
        int schemeStart;
        int schemeIndex = str.indexOf(SCHEME_URL, startIndex + 1);
        if (schemeIndex <= 0) {
            return -1;
        }
        for (schemeStart = schemeIndex - 1; schemeStart >= 0 && HyperlinkUtil.isValidSchemeChar(currentChar = str.charAt(schemeStart)); --schemeStart) {
        }
        return ++schemeStart;
    }

    @VisibleForTesting
    static String linkEmail(String string) {
        StringBuffer sb = new StringBuffer(string);
        HyperlinkUtil.linkEmail(sb);
        return sb.toString();
    }

    private static void linkEmail(StringBuffer str) {
        int atIndex;
        int lastEndIndex = -1;
        block0: while ((atIndex = str.indexOf("@", lastEndIndex + 1)) != -1) {
            char lastChar;
            char c;
            StringBuilder partBeforeAt = new StringBuilder();
            int linkStartIndex = atIndex;
            while (--linkStartIndex >= 0) {
                char c2 = str.charAt(linkStartIndex);
                if (c2 == '?' || c2 == '&' || c2 == '=' || c2 == '/' || c2 == '%') {
                    lastEndIndex = atIndex + 1;
                    continue block0;
                }
                if (!HyperlinkUtil.isValidEmailChar(c2)) break;
                partBeforeAt.insert(0, c2);
            }
            ++linkStartIndex;
            StringBuilder partAfterAt = new StringBuilder();
            int linkEndIndex = atIndex;
            while (++linkEndIndex != str.length() && HyperlinkUtil.isValidEmailChar(c = str.charAt(linkEndIndex))) {
                partAfterAt.append(c);
            }
            --linkEndIndex;
            Object emailStr = partBeforeAt.toString() + "@" + String.valueOf(partAfterAt);
            while ((lastChar = ((String)emailStr).charAt(((String)emailStr).length() - 1)) == '.' || lastChar == ':' || lastChar == '-' || lastChar == '/' || lastChar == '~') {
                emailStr = ((String)emailStr).substring(0, ((String)emailStr).length() - 1);
                --linkEndIndex;
            }
            if (EmailValidator.getInstance().isValid((String)emailStr)) {
                String emailLink = "<a href='mailto:" + (String)emailStr + "'>" + (String)emailStr + "</a>";
                str.replace(linkStartIndex, linkEndIndex + 1, emailLink);
                lastEndIndex = linkStartIndex - 1 + emailLink.length();
                continue;
            }
            lastEndIndex = linkStartIndex - 1 + ((String)emailStr).length();
        }
    }

    @VisibleForTesting
    static String linkURL(String string) {
        StringBuffer sb = new StringBuffer(string);
        HyperlinkUtil.linkURL(sb);
        return sb.toString();
    }

    private static void linkURL(StringBuffer str) {
        int linkStartIndex;
        int lastEndIndex = -1;
        while ((linkStartIndex = HyperlinkUtil.getStartUrl(str, lastEndIndex)) != -1) {
            char lastChar;
            String suffix;
            String prefix;
            int linkEndIndex = linkStartIndex;
            Object urlStr = "";
            StringBuilder tmpUrlStr = new StringBuilder();
            do {
                if (str.charAt(linkEndIndex) == '&') {
                    if (linkEndIndex + 6 <= str.length() && "&quot;".equals(str.substring(linkEndIndex, linkEndIndex + 6))) break;
                    if (linkEndIndex + 5 <= str.length() && "&amp;".equals(str.substring(linkEndIndex, linkEndIndex + 5))) {
                        str.replace(linkEndIndex, linkEndIndex + 5, "&");
                    }
                }
                if (!HyperlinkUtil.isValidURLChar(str.charAt(linkEndIndex))) break;
                tmpUrlStr.append(str.charAt(linkEndIndex));
            } while (++linkEndIndex != str.length());
            urlStr = tmpUrlStr.toString();
            if (linkStartIndex >= 6 && "href=\"".equals(prefix = str.substring(linkStartIndex - 6, linkStartIndex))) {
                lastEndIndex = linkEndIndex;
                continue;
            }
            if (str.length() >= linkEndIndex + 4 && "</a>".equals(suffix = str.substring(linkEndIndex, linkEndIndex + 4))) {
                lastEndIndex = linkEndIndex + 4;
                continue;
            }
            --linkEndIndex;
            while ((lastChar = ((String)urlStr).charAt(((String)urlStr).length() - 1)) == '.') {
                urlStr = ((String)urlStr).substring(0, ((String)urlStr).length() - 1);
                --linkEndIndex;
            }
            lastChar = ((String)urlStr).charAt(((String)urlStr).length() - 1);
            if (lastChar == ')') {
                if (linkStartIndex > 0 && '(' == str.charAt(linkStartIndex - 1)) {
                    urlStr = ((String)urlStr).substring(0, ((String)urlStr).length() - 1);
                    --linkEndIndex;
                }
            } else if (lastChar == '\'') {
                if (linkStartIndex > 0 && '\'' == str.charAt(linkStartIndex - 1)) {
                    urlStr = ((String)urlStr).substring(0, ((String)urlStr).length() - 1);
                    --linkEndIndex;
                }
            } else if (lastChar == ';') {
                String endingStr;
                if (((String)urlStr).length() > 6 && "&quot;".equalsIgnoreCase(((String)urlStr).substring(((String)urlStr).length() - 6))) {
                    urlStr = ((String)urlStr).substring(0, ((String)urlStr).length() - 6);
                    linkEndIndex -= 6;
                } else if (((String)urlStr).length() > 4 && ("&lt;".equalsIgnoreCase(endingStr = ((String)urlStr).substring(((String)urlStr).length() - 4)) || "&gt;".equalsIgnoreCase(endingStr))) {
                    urlStr = ((String)urlStr).substring(0, ((String)urlStr).length() - 4);
                    linkEndIndex -= 4;
                }
            }
            String urlToDisplay = PlainTextToHtmlConverter.encodeHtmlEntities((String)urlStr);
            if (((String)urlStr).toLowerCase().startsWith("www.")) {
                urlStr = "http://" + (String)urlStr;
            }
            if (HyperlinkUtil.verifyHierachicalURI((String)urlStr, new String[]{"javascript"})) {
                String urlLink = "<a href=\"" + (String)urlStr + "\">" + urlToDisplay + "</a>";
                str.replace(linkStartIndex, linkEndIndex + 1, urlLink);
                lastEndIndex = linkStartIndex - 1 + urlLink.length();
                continue;
            }
            lastEndIndex = linkStartIndex - 1 + ((String)urlStr).length();
        }
    }

    private static boolean isAcceptableReservedChar(char c) {
        return c == ';' || c == '/' || c == '?' || c == ':' || c == '@' || c == '&' || c == '=' || c == '+' || c == '$' || c == ',';
    }

    private static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isOtherChar(char c) {
        return c == '#' || c == '%';
    }

    private static boolean isUnreservedChar(char c) {
        return c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')';
    }

    private static boolean isValidEmailChar(char c) {
        return HyperlinkUtil.isAlpha(c) || HyperlinkUtil.isDigit(c) || c == '_' || c == '-' || c == '.';
    }

    private static boolean isValidScheme(String scheme) {
        if (scheme == null || scheme.isEmpty()) {
            return false;
        }
        char[] schemeChars = scheme.toCharArray();
        if (!HyperlinkUtil.isAlpha(schemeChars[0])) {
            return false;
        }
        for (int i = 1; i < schemeChars.length; ++i) {
            char schemeChar = schemeChars[i];
            if (HyperlinkUtil.isValidSchemeChar(schemeChar)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidSchemeChar(char c) {
        return HyperlinkUtil.isAlpha(c) || HyperlinkUtil.isDigit(c) || c == '+' || c == '-' || c == '.';
    }

    private static boolean isValidURLChar(char c) {
        return HyperlinkUtil.isAlpha(c) || HyperlinkUtil.isDigit(c) || HyperlinkUtil.isAcceptableReservedChar(c) || HyperlinkUtil.isUnreservedChar(c) || HyperlinkUtil.isOtherChar(c);
    }

    public static boolean verifyHierachicalURI(String uri) {
        return HyperlinkUtil.verifyHierachicalURI(uri, null);
    }

    private static boolean verifyHierachicalURI(String uri, String[] schemesConsideredInvalid) {
        if (uri == null || uri.length() < SCHEME_URL.length()) {
            return false;
        }
        int schemeUrlIndex = uri.indexOf(SCHEME_URL);
        if (schemeUrlIndex == -1) {
            return false;
        }
        String scheme = uri.substring(0, schemeUrlIndex);
        if (!HyperlinkUtil.isValidScheme(scheme)) {
            return false;
        }
        if (schemesConsideredInvalid != null) {
            for (String invalidScheme : schemesConsideredInvalid) {
                if (!scheme.equalsIgnoreCase(invalidScheme)) continue;
                return false;
            }
        }
        if (uri.length() < schemeUrlIndex + SCHEME_URL.length() + 1) {
            return false;
        }
        for (int i = schemeUrlIndex + SCHEME_URL.length(); i < uri.length(); ++i) {
            if (HyperlinkUtil.isValidURLChar(uri.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

