/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.plugin.descriptor.ThemeModuleDescriptor;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.themes.ThemeManager;
import java.util.List;

public class LayoutHelper {
    public static final String TEMPLATE_PATH = "velocity";
    protected static final String FS = System.getProperty("file.separator");
    public static final String THEME_ICON = "themeicon.gif";
    public static final String GLOBAL_CONFIGPATH = "global-config-path";
    public static final String SPACE_CONFIGPATH = "space-config-path";
    private ThemeManager themeManager;
    private boolean isGlobal = true;
    public static final List<String> BUTTON_VALUE_LIST = List.of("global", "custom", "theme");

    public ThemeModuleDescriptor findThemeDescriptor(String moduleCompleteKey) {
        return this.themeManager.getAvailableThemeDescriptors().stream().filter(d -> d.getCompleteKey().equals(moduleCompleteKey)).findFirst().orElse(null);
    }

    public boolean hasIcon(ThemeModuleDescriptor descriptor) {
        return descriptor.getResourceDescriptor("download", THEME_ICON) != null;
    }

    public String getConfigPath(ThemeModuleDescriptor descriptor, String configPath) {
        if (descriptor.getParams().containsKey(configPath)) {
            return (String)descriptor.getParams().get(configPath);
        }
        return null;
    }

    public List<String> getColourSchemeTypes() {
        return BUTTON_VALUE_LIST;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean global) {
        this.isGlobal = global;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public static String getFullTemplatePath() {
        BootstrapManager bootstrapManager = (BootstrapManager)BootstrapUtils.getBootstrapManager();
        return bootstrapManager.getConfluenceHome() + System.getProperty("file.separator") + TEMPLATE_PATH;
    }
}

