/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.util.logging.LoggingContext;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.interceptor.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingContextInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingContextInterceptor.class);

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation actionInvocation) throws Exception {
        try {
            this.buildLoggingContext(actionInvocation);
        }
        catch (Exception ex) {
            log.error("Exception while building logging context", (Throwable)ex);
        }
        try {
            String string = actionInvocation.invoke();
            return string;
        }
        finally {
            this.cleanLoggingContext();
        }
    }

    protected void buildLoggingContext(ActionInvocation actionInvocation) {
        SpaceAware spaceAware;
        Space space;
        PageAware pageAware;
        Object page;
        Object object = actionInvocation.getAction();
        if (object instanceof PageAware && (page = (pageAware = (PageAware)object).getPage()) != null) {
            LoggingContext.put((String)"page", (Object)((ContentEntityObject)page).getIdAsString());
        }
        if ((page = actionInvocation.getAction()) instanceof SpaceAware && (space = (spaceAware = (SpaceAware)page).getSpace()) != null) {
            LoggingContext.put((String)"space", (Object)Long.toString(space.getId()));
        }
        LoggingContext.put((String)"action", (Object)actionInvocation.getInvocationContext().getActionName());
    }

    protected void cleanLoggingContext() {
        LoggingContext.remove((String[])new String[]{"action"});
        LoggingContext.remove((String[])new String[]{"space"});
        LoggingContext.remove((String[])new String[]{"page"});
    }
}

