/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.plugin.PluginAccessor;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
public class MobileAppRequestFilter
extends HttpFilter {
    private static final String MOBILE_REQUEST_HEADER_NAME = "mobile-app-request";
    private static final String MOBILE_DISABLED_HEADER_NAME = "mobile-app-disabled";
    private static final String MOBILE_PLUGIN_KEY = "com.atlassian.confluence.plugins.confluence-mobile-plugin";
    private final Supplier<PluginAccessor> pluginManagerSupplier = MemoizingComponentReference.containerComponent("pluginManager");

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String mobileRequestHeader = request.getHeader(MOBILE_REQUEST_HEADER_NAME);
        if (StringUtils.isNotBlank((CharSequence)mobileRequestHeader) && Boolean.valueOf(mobileRequestHeader).booleanValue() && !this.getPluginManager().isPluginEnabled(MOBILE_PLUGIN_KEY)) {
            response.setHeader(MOBILE_DISABLED_HEADER_NAME, "true");
            response.sendError(503);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private PluginAccessor getPluginManager() {
        return this.pluginManagerSupplier.get();
    }
}

