/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import brave.Span;
import brave.Tracing;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import com.atlassian.confluence.util.logging.LoggingContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.spring.container.LazyComponentReference;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;

@UnrestrictedAccess
public class RequestCacheThreadLocalFilter
implements Filter {
    private static final String MOBILE_APP_REQUEST = "mobile-app-request";
    private final Supplier<Tracing> tracingReference = new LazyComponentReference("tracing");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        block6: {
            try {
                RequestCacheThreadLocal.setRequestCache(new HashMap());
                if (servletRequest instanceof HttpServletRequest) {
                    RequestCacheThreadLocal.getRequestCache().put("confluence.context.path", ((HttpServletRequest)servletRequest).getContextPath());
                    RequestCacheThreadLocal.getRequestCache().put("request.remote.address", servletRequest.getRemoteAddr());
                    RequestCacheThreadLocal.getRequestCache().put("x.forwarded.for", ((HttpServletRequest)servletRequest).getHeader("X-Forwarded-For"));
                    RequestCacheThreadLocal.getRequestCache().put("header.mobile.app.request", ((HttpServletRequest)servletRequest).getHeader(MOBILE_APP_REQUEST));
                    String traceId = this.obtainTraceId();
                    RequestCacheThreadLocal.getRequestCache().put("request.correlation.id", traceId);
                    LoggingContext.put((String)"traceId", (Object)traceId);
                    try {
                        filterChain.doFilter(servletRequest, servletResponse);
                    }
                    catch (Throwable throwable) {
                        LoggingContext.remove((String[])new String[]{"traceId", traceId});
                        throw throwable;
                    }
                    LoggingContext.remove((String[])new String[]{"traceId", traceId});
                    break block6;
                }
                filterChain.doFilter(servletRequest, servletResponse);
            }
            finally {
                RequestCacheThreadLocal.clearRequestCache();
            }
        }
    }

    private String obtainTraceId() {
        Span currentSpan;
        Optional<Long> traceId = Optional.empty();
        if (ContainerManager.isContainerSetup() && (currentSpan = this.tracingReference.get().tracer().currentSpan()) != null) {
            traceId = Optional.of(currentSpan.context().traceId());
        }
        return String.format("%016x", traceId.orElseGet(() -> ThreadLocalRandom.current().nextLong(0x100000000000000L)));
    }
}

