/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.UrlUtils;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.ioc.ApplicationServicesRegistry;
import com.atlassian.seraph.util.RedirectUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SeraphUtils {
    public static String getLoginURL(HttpServletRequest request) {
        return RedirectUtils.getLoginUrl((HttpServletRequest)request);
    }

    public static String getLinkLoginURL(HttpServletRequest request, String username) {
        String url = SeraphUtils.getLinkLoginURL(request);
        if (StringUtils.isBlank((CharSequence)username)) {
            return url;
        }
        return UrlUtils.appendAmpersandOrQuestionMark(url) + "os_username=" + HtmlUtil.urlEncode(username, GeneralUtil.getDefaultCharset());
    }

    public static String getLinkLoginURL(HttpServletRequest request) {
        Object linkLoginURL = RedirectUtils.getLinkLoginURL((HttpServletRequest)request);
        String currentPageUrl = request.getRequestURI() + (String)(StringUtils.isNotEmpty((CharSequence)request.getQueryString()) ? "?" + request.getQueryString() : "");
        if (currentPageUrl.contains("/logout.action") || currentPageUrl.contains("/login.action") || currentPageUrl.contains("/signup.action") || currentPageUrl.contains("/dosignup.action")) {
            return linkLoginURL;
        }
        Object destination = request.getParameter("atl_after_login_redirect");
        if (StringUtils.isBlank((CharSequence)destination)) {
            destination = currentPageUrl.contains("forgotuserpassword.action") || currentPageUrl.contains("confirmemail.action") ? "/homepage.action" : currentPageUrl;
        }
        destination = SeraphUtils.stripContextPathFromRequestURL(request, (String)destination);
        linkLoginURL = UrlUtils.appendAmpersandOrQuestionMark((String)linkLoginURL);
        linkLoginURL = (String)linkLoginURL + "os_destination=" + HtmlUtil.urlEncode((String)destination, GeneralUtil.getDefaultCharset());
        return linkLoginURL;
    }

    public static String getLinkLoginURLAndStripContextPath(HttpServletRequest request) {
        String linkLoginURL = SeraphUtils.getLinkLoginURL(request);
        return SeraphUtils.stripContextPathFromRequestURL(request, linkLoginURL);
    }

    public static String stripContextPathFromRequestURL(HttpServletRequest request, String currentPageUrl) {
        if (currentPageUrl.startsWith(request.getContextPath())) {
            currentPageUrl = currentPageUrl.substring(request.getContextPath().length());
        }
        return currentPageUrl;
    }

    public static String getOriginalURL(HttpServletRequest request) {
        String originalURL;
        SecurityConfig config = SeraphUtils.getConfig(request);
        if (config != null && StringUtils.isNotEmpty((CharSequence)(originalURL = (String)request.getSession().getAttribute(config.getOriginalURLKey())))) {
            return originalURL;
        }
        return request.getParameter("os_destination");
    }

    public static SecurityConfig getConfig(HttpServletRequest request) {
        return (SecurityConfig)request.getSession().getServletContext().getAttribute("seraph_config");
    }

    public static boolean authenticate(HttpServletRequest request, HttpServletResponse response, Principal principal, String password) throws AuthenticatorException {
        return SeraphUtils.authenticate(request, response, principal, password, SeraphUtils.getConfig(request));
    }

    static boolean authenticate(HttpServletRequest request, HttpServletResponse response, Principal principal, String password, @Nullable SecurityConfig securityConfig) throws AuthenticatorException {
        return securityConfig != null && securityConfig.getAuthenticator().login(request, response, principal.getName(), password);
    }

    public static void addRememberMeCookie(HttpServletRequest request, HttpServletResponse response, Principal principal) {
        ApplicationServicesRegistry.getRememberMeService().addRememberMeCookie(request, response, principal.getName());
    }
}

