/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.jmx.CurrentTimeFacade;
import com.atlassian.confluence.util.FileSanitizer;
import com.atlassian.confluence.util.ZipUtility;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.Validateable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportUtility
implements Validateable {
    private static final String SANITIZER_MESSAGE = "Sanitized by Support Utility";
    private static final Logger log = LoggerFactory.getLogger(SupportUtility.class);
    private static final Map<String, List<Pattern>> FILE_PATTERNS = new HashMap<String, List<Pattern>>();
    static final Pattern TOMCAT_USERS_SANITIZER_PATTERN = Pattern.compile(".*?<user\\b(?>username=(?:\"|')([^'\"]*)(?:\"|')|password=(?:\"|')([^'\"]*)(?:\"|')|[^\\s>]+|\\s+)+/?>.*?", 2);
    private final ConfluenceActionSupport actionSupport;
    private final String localHomeDirectory;
    private final String webInfClassesDir;
    private boolean includeLogs;
    private boolean includeServerLogs;
    private String serverLogsDirectory;
    private boolean includeTomcatConf;
    private boolean includeCfgFile;
    private boolean includeUserFiles;

    public SupportUtility(ConfluenceActionSupport actionSupport, String localHomeDirectory, String webInfClassesDir) {
        this.actionSupport = actionSupport;
        this.localHomeDirectory = localHomeDirectory;
        this.webInfClassesDir = webInfClassesDir;
        this.includeLogs = false;
        this.includeServerLogs = false;
        this.serverLogsDirectory = null;
        this.includeTomcatConf = false;
        this.includeCfgFile = false;
        this.includeUserFiles = false;
    }

    public void setDefaults() {
        this.includeLogs = true;
        this.includeServerLogs = true;
        this.includeTomcatConf = true;
        this.includeCfgFile = true;
        this.includeUserFiles = true;
    }

    public void validate() {
        if (this.isTomcatServer() || !this.includeServerLogs) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.serverLogsDirectory)) {
            this.actionSupport.addFieldError("serverLogsDirectory", this.actionSupport.getText("create.support.zip.error.no.log"));
            return;
        }
        if (!new File(this.serverLogsDirectory).exists()) {
            this.actionSupport.addFieldError("serverLogsDirectory", this.actionSupport.getText("create.support.zip.error.invalid.path"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSupportZip(File supportZip) throws IOException {
        try {
            supportZip.createNewFile();
        }
        catch (IOException e) {
            throw new IOException(e.getMessage() + " - " + supportZip.getAbsolutePath());
        }
        FileSanitizer sanitizer = new FileSanitizer(FILE_PATTERNS, SANITIZER_MESSAGE);
        ZipUtility.FileHandler sanitizeFileHandler = f -> {
            try {
                return sanitizer.sanitize(f);
            }
            catch (IOException ioe) {
                log.error("Could not sanitize file: {}", (Object)f.getAbsolutePath(), (Object)ioe);
                return f;
            }
        };
        ZipUtility zipper = new ZipUtility(sanitizeFileHandler);
        this.addFilesToZip(zipper);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(supportZip));){
            zipper.zip((OutputStream)out);
        }
        finally {
            sanitizer.cleanUpTempFiles();
        }
        log.info("Saved Support Zip to: {}", (Object)supportZip.getAbsolutePath());
    }

    private void addFilesToZip(ZipUtility zipUtility) {
        File[] serverLogFiles;
        File serverLogsDir;
        File confluenceLogsDir;
        File[] confluenceLogFiles;
        if (this.includeLogs && (confluenceLogFiles = (confluenceLogsDir = new File(this.localHomeDirectory, "logs")).listFiles((FilenameFilter)new RegexFileFilter("^.*\\.log.*"))) != null) {
            for (File confluenceLogFile : confluenceLogFiles) {
                zipUtility.add("Confluence_Home/logs/" + confluenceLogFile.getName(), new File(confluenceLogsDir, confluenceLogFile.getName()));
            }
        }
        if (this.includeCfgFile) {
            File file = new File(this.localHomeDirectory, "confluence.cfg.xml");
            if (file.exists()) {
                log.debug("adding confluence.cfg.xml to zip");
                zipUtility.add("Confluence_Home/confluence.cfg.xml", file);
            } else {
                log.debug("Unable to find confluence.cfg.xml at: {}", (Object)file.getAbsolutePath());
            }
        }
        if (this.includeServerLogs && (serverLogsDir = this.isTomcatServer() ? this.findTomcatFileOrDirectory("logs") : new File(this.serverLogsDirectory)) != null && serverLogsDir.exists() && (serverLogFiles = serverLogsDir.listFiles((FilenameFilter)new RegexFileFilter("^.*\\.log|^.*\\.out"))) != null) {
            for (File serverLogFile : serverLogFiles) {
                if (!serverLogFile.isFile()) continue;
                zipUtility.add("Server/logs/" + serverLogFile.getName(), new File(serverLogsDir, serverLogFile.getName()));
            }
        }
        if (this.isTomcatServer() && this.includeTomcatConf) {
            zipUtility.add("Tomcat/conf", this.findTomcatFileOrDirectory("conf"));
        }
        if (this.includeUserFiles) {
            zipUtility.add("WEB-INF/classes/atlassian-user.xml", new File(this.webInfClassesDir, "atlassian-user.xml"));
            zipUtility.add("WEB-INF/classes/osuser.xml", new File(this.webInfClassesDir, "osuser.xml"));
            zipUtility.add("WEB-INF/classes/crowd.properties", new File(this.webInfClassesDir, "crowd.properties"));
        }
        zipUtility.add("WEB-INF/classes/confluence-init.properties", new File(this.webInfClassesDir, "confluence-init.properties"));
        zipUtility.add("WEB-INF/classes/log4j.properties", new File(this.webInfClassesDir, "log4j.properties"));
        zipUtility.add("WEB-INF/classes/seraph-config.xml", new File(this.webInfClassesDir, "seraph-config.xml"));
        zipUtility.add("Confluence_Home/config", new File(this.localHomeDirectory, "config"));
    }

    public File createSupportZip() throws IOException {
        File supportDir = new File(this.localHomeDirectory, "logs/support");
        if (!supportDir.exists() && !supportDir.mkdirs()) {
            throw new IOException("Couldn't create export directory " + supportDir.getAbsolutePath());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String filename = "confluence_support_" + format.format(CurrentTimeFacade.getCurrentTime()) + ".zip";
        File supportZipFile = new File(supportDir, filename);
        this.createSupportZip(supportZipFile);
        return supportZipFile;
    }

    private File findTomcatFileOrDirectory(String fileOrDirectoryName) {
        String catalinaBase = System.getProperty("catalina.base");
        File file = new File(catalinaBase, fileOrDirectoryName);
        if (file.exists()) {
            return file;
        }
        String catalinaHome = System.getProperty("catalina.home");
        file = new File(catalinaHome, fileOrDirectoryName);
        if (file.exists()) {
            return file;
        }
        String workingDirecotry = System.getProperty("working.dir");
        file = new File(workingDirecotry + "../", fileOrDirectoryName);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public boolean isTomcatServer() {
        return ServletActionContext.getServletContext().getServerInfo().contains("Tomcat");
    }

    public boolean isIncludeLogs() {
        return this.includeLogs;
    }

    public void setIncludeLogs(boolean includeLogs) {
        this.includeLogs = includeLogs;
    }

    public boolean isIncludeServerLogs() {
        return this.includeServerLogs;
    }

    public void setIncludeServerLogs(boolean includeServerLogs) {
        this.includeServerLogs = includeServerLogs;
    }

    public String getServerLogsDirectory() {
        return this.serverLogsDirectory;
    }

    public void setServerLogsDirectory(String serverLogsDirectory) {
        this.serverLogsDirectory = serverLogsDirectory;
    }

    public boolean isIncludeTomcatConf() {
        return this.includeTomcatConf;
    }

    public void setIncludeTomcatConf(boolean includeTomcatConf) {
        this.includeTomcatConf = includeTomcatConf;
    }

    public boolean isIncludeCfgFile() {
        return this.includeCfgFile;
    }

    public void setIncludeCfgFile(boolean includeCfgFile) {
        log.debug("Setting include config file to: {}", (Object)includeCfgFile);
        this.includeCfgFile = includeCfgFile;
    }

    public boolean isIncludeUserFiles() {
        return this.includeUserFiles;
    }

    public void setIncludeUserFiles(boolean includeUserFiles) {
        this.includeUserFiles = includeUserFiles;
    }

    static {
        FILE_PATTERNS.put("confluence.cfg.xml", List.of(Pattern.compile("(?:.*<property name=\"confluence\\.license\\.message\">)(.*)(?:</property>.*)"), Pattern.compile("(?:.*<property name=\"hibernate\\.connection\\.password\">)(.*)(?:</property>.*)"), Pattern.compile("(?:.*<property name=\"hibernate\\.connection\\.username\">)(.*)(?:</property>.*)")));
        FILE_PATTERNS.put("atlassian-user.xml", List.of(Pattern.compile("(?:.*<securityPrincipal>)(.*)(?:</securityPrincipal>.*)"), Pattern.compile("(?:.*<securityCredential>)(.*)(?:</securityCredential>.*)")));
        FILE_PATTERNS.put("tomcat-users.xml", List.of(TOMCAT_USERS_SANITIZER_PATTERN));
    }
}

