/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.annotations.security.UnrestrictedAccess;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
public class UserNameHeaderFilter
extends HttpFilter {
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String username = request.getRemoteUser();
        if (StringUtils.isNotEmpty((CharSequence)username) && !UserNameHeaderFilter.isStaticResourcePath(request.getServletPath(), request.getPathInfo())) {
            response.setHeader("X-AUSERNAME", username);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private static boolean isStaticResourcePath(String servletPath, String pathInfo) {
        return "/s".equals(servletPath) || "/download".equals(servletPath) && (pathInfo.startsWith("/resources") || pathInfo.startsWith("/sources") || pathInfo.startsWith("/contextbatch") || pathInfo.startsWith("/batch"));
    }
}

