/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.MemoizingComponentReference;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
public class UserThreadLocalFilter
extends HttpFilter {
    protected Supplier<UserAccessor> userAccessor = MemoizingComponentReference.containerComponent("userAccessor");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ConfluenceUser existingUser = null;
        try {
            if (GeneralUtil.isSetupComplete()) {
                ConfluenceUser user = this.getUserFromRequest(request);
                existingUser = AuthenticatedUserThreadLocal.get();
                AuthenticatedUserThreadLocal.set(user);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable throwable) {
            AuthenticatedUserThreadLocal.set(existingUser);
            throw throwable;
        }
        AuthenticatedUserThreadLocal.set(existingUser);
    }

    private ConfluenceUser getUserFromRequest(HttpServletRequest request) {
        String username = request.getRemoteUser();
        if (StringUtils.isEmpty((CharSequence)username)) {
            return null;
        }
        return this.getUserAccessor().getUserByName(username);
    }

    protected UserAccessor getUserAccessor() {
        return this.userAccessor.get();
    }
}

