/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.datetime.RequestTimeThreadLocalFilter;
import com.atlassian.confluence.event.events.analytics.HttpRequestStats;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.search.v2.summary.Summarizer;
import com.atlassian.confluence.search.v2.summary.Summary;
import com.atlassian.confluence.setup.BuildInformation;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.confluence.util.UrlUtils;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.core.util.XMLUtils;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.renderer.util.RendererUtil;
import com.atlassian.spring.container.ComponentNotFoundException;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.atlassian.util.profiling.UtilTimerStack;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class VelocityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(VelocityUtil.class);
    public static final VelocityUtil INSTANCE = new VelocityUtil();
    protected static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    protected static final String ELLIPSIS = "\u2026";
    private static final String EMAIL_PATTERN_STRING = "([\\w\\-%+.]+@[\\w\\-%.]+\\.\\p{Alpha}+)";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("([\\w\\-%+.]+@[\\w\\-%.]+\\.\\p{Alpha}+)");
    private static final Supplier<UserAccessor> userAccessorRef = MemoizingComponentReference.containerComponent("userAccessor");
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;

    protected VelocityUtil() {
    }

    @HtmlSafe
    public static String customGetPageUrl(AbstractPage page) {
        String pageUrl = page.getUrlPath();
        return VelocityUtil.appendAmpersandOrQuestionMark(pageUrl);
    }

    @HtmlSafe
    @Deprecated(forRemoval=true)
    public static String appendAmpersandOrQuestionMark(String str) {
        return UrlUtils.appendAmpersandOrQuestionMark(str);
    }

    @Deprecated
    public static String doubleUrlEncode(String url) {
        return HtmlUtil.urlEncode(HtmlUtil.urlEncode(url));
    }

    public static boolean isAllAscii(String s) {
        char[] sChars;
        for (char sChar : sChars = s.toCharArray()) {
            if (VelocityUtil.isAscii(sChar)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isAscii(char c) {
        return c < '\u0080';
    }

    public static String getVersionNumber() {
        return BuildInformation.INSTANCE.getVersionNumber();
    }

    public static String getBuildNumber() {
        return BuildInformation.INSTANCE.getBuildNumber();
    }

    @Deprecated
    public static boolean isLicenseExpired() {
        ApplicationContext context = BootstrapUtils.getBootstrapContext();
        if (context == null) {
            return false;
        }
        LicenseService licenseService = (LicenseService)context.getBean("licenseService");
        ConfluenceLicense license = licenseService.retrieve();
        return license.isExpired();
    }

    public static String getCharacterEncoding() {
        try {
            Settings globalSettings = GeneralUtil.getGlobalSettings();
            if (globalSettings == null) {
                LOG.debug("Null instance of GlobalSettings. Will use {} as default encoding", (Object)DEFAULT_CHARACTER_ENCODING);
                return DEFAULT_CHARACTER_ENCODING;
            }
            return globalSettings.getDefaultEncoding();
        }
        catch (ComponentNotFoundException ex) {
            LOG.warn("Could not obtain an instance of GlobalSettings");
            return DEFAULT_CHARACTER_ENCODING;
        }
    }

    @HtmlSafe
    public static String escapeXml(String stringToEscape) {
        return XMLUtils.escape((String)stringToEscape);
    }

    public static String[] escapeXml(Object[] args) {
        String[] encodedArgs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            encodedArgs[i] = VelocityUtil.escapeXml(String.valueOf(args[i]));
        }
        return encodedArgs;
    }

    public static String maskEmail(String emailAddress, Settings globalSettings) {
        if (emailAddress == null || "email.address.public".equals(globalSettings.getEmailAddressVisibility())) {
            return emailAddress;
        }
        if ("email.address.private".equals(globalSettings.getEmailAddressVisibility())) {
            return "";
        }
        return GeneralUtil.alwaysMaskEmail(emailAddress);
    }

    public static String findAndMaskEmail(String text, User currentUser) {
        if (currentUser != null && userAccessorRef.get().hasMembership("confluence-administrators", currentUser.getName())) {
            return text;
        }
        if (StringUtils.isEmpty((CharSequence)text) || "email.address.public".equals(GeneralUtil.getGlobalSettings().getEmailAddressVisibility())) {
            return text;
        }
        Matcher matcher = EMAIL_PATTERN.matcher(text);
        StringBuilder sb = new StringBuilder(text.length());
        while (matcher.find()) {
            matcher.appendReplacement(sb, VelocityUtil.maskEmail(matcher.group(0), GeneralUtil.getGlobalSettings()));
        }
        if (sb.isEmpty()) {
            return text;
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String base64Decode(String s) {
        try {
            String s1 = s.replaceAll("_", "/");
            String s2 = s1.replaceAll("-", "+");
            byte[] sBytes = s2.getBytes();
            return new String(Base64.decodeBase64((byte[])sBytes), DEFAULT_CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("This Java installation doesn't support UTF-8. Call Mulder");
            return s;
        }
    }

    public static String base64Encode(String s) {
        byte[] sBytes = s.getBytes(StandardCharsets.UTF_8);
        return Base64.encodeBase64URLSafeString((byte[])sBytes);
    }

    public static boolean isInLastDays(Date date, int maxDays) {
        if (date == null) {
            return false;
        }
        long tstamp = date.getTime();
        long t0 = System.currentTimeMillis();
        long dt = t0 - tstamp;
        long secs = dt / 1000L;
        long mins = secs / 60L;
        long hours = mins / 60L;
        long days = hours / 24L;
        return days < (long)maxDays;
    }

    public static String getFormatDateSimple(Date date) {
        return new SimpleDateFormat("dd MMM").format(date);
    }

    @HtmlSafe
    public static String plain2html(String text) {
        return PlainTextToHtmlConverter.toHtml(text);
    }

    @Deprecated
    @HtmlSafe
    public static String htmlEscapeQuotes(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return "";
        }
        return PlainTextToHtmlConverter.encodeHtmlEntities(input.replaceAll("'", "\\\\'").replaceAll("\"", "\\\\\""));
    }

    public static String shortenString(String str, int max) {
        if (StringUtils.isNotBlank((CharSequence)str) && str.length() > max) {
            return str.substring(0, max) + ELLIPSIS;
        }
        return str;
    }

    public static String replaceConfluenceConstants(String in, File home, File localHome) {
        return StringUtils.replace((String)StringUtils.replace((String)in, (String)"${confluenceHome}", (String)home.getPath()), (String)"${localHome}", (String)localHome.getPath());
    }

    public static <T> List<T> safeSubList(List<T> list, int max) {
        if (list == null || list.size() < max) {
            return list;
        }
        return list.subList(0, max);
    }

    public static String summarise(String content) {
        return RendererUtil.summarise((String)content);
    }

    public static Summary makeSummary(String content, @Nullable String query) {
        Summary summary;
        block8: {
            summary = null;
            try {
                String strippedContent = RendererUtil.stripBasicMarkup((String)content);
                strippedContent = strippedContent.replaceAll("&nbsp;", "\u00a0");
                if (strippedContent.trim().isEmpty()) break block8;
                Summarizer s = (Summarizer)ContainerManager.getComponent((String)"summarizer");
                try (Ticker ignored = Timers.start((String)"Summarizer.getSummary");){
                    summary = s.getSummary(strippedContent, query);
                }
            }
            catch (IOException e) {
                LOG.error("Could not create summary of content '{}' with query '{}'", new Object[]{content, query, e});
            }
        }
        return summary;
    }

    public static String makeFlatSummary(String content, @Nullable String query) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        Summary summary = VelocityUtil.makeSummary(content, query);
        if (summary == null) {
            return content;
        }
        StringBuilder excerpt = new StringBuilder();
        for (Summary.Fragment f : summary.getFragments()) {
            excerpt.append(f.getText());
        }
        return excerpt.toString();
    }

    public static String lookupDomainName(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        Object port = "";
        if (!VelocityUtil.isStandardPort(request.getScheme(), request.getServerPort())) {
            port = ":" + request.getServerPort();
        }
        return request.getScheme() + "://" + request.getServerName() + (String)port + request.getContextPath();
    }

    private static boolean isStandardPort(String scheme, int port) {
        return "http".equalsIgnoreCase(scheme) && port == 80 || "https".equalsIgnoreCase(scheme) && port == 443;
    }

    public static String trimDownStringToWord(String s) {
        if (s != null && s.length() > 60) {
            return WordUtils.abbreviate((String)s, (int)60, (int)72, (String)ELLIPSIS);
        }
        return s;
    }

    public static boolean isDateWithin24Hours(Date date) {
        return Instant.now().minus(1L, ChronoUnit.DAYS).isBefore(date.toInstant());
    }

    public static Duration getServerRenderTime(ServletRequest servletRequest) {
        return VelocityUtil.getDuration(servletRequest, Instant::now);
    }

    private static Duration getDuration(ServletRequest servletRequest, Supplier<Instant> now) {
        return RequestTimeThreadLocalFilter.getRequestStartTime(servletRequest).map(start -> Duration.between(start, (Temporal)now.get())).orElse(Duration.ZERO);
    }

    public static String getRequestCorrelationId() {
        return RequestCacheThreadLocal.getRequestCorrelationId();
    }

    public static void flushResponse() {
        StaticHttpContext httpContext = new StaticHttpContext();
        HttpServletResponse response = httpContext.getActiveResponse();
        HttpServletRequest request = httpContext.getActiveRequest();
        try {
            if (response != null && request != null && request.getAttribute("com.atlassian.confluence.util.profiling.ConfluenceSitemeshDecorator") != null) {
                response.getWriter().flush();
            }
        }
        catch (Exception e) {
            LOG.error("Error flushing response", (Throwable)e);
        }
    }

    public static void elapse(String tag) {
        HttpRequestStats.elapse(tag);
    }

    public static List<String> sortList(List<String> list) {
        ArrayList<String> newList = new ArrayList<String>(list);
        Collections.sort(newList);
        return newList;
    }

    @Deprecated
    public static void profilePush(String s) {
        UtilTimerStack.push((String)s);
    }

    @Deprecated
    public static void profilePop(String s) {
        UtilTimerStack.pop((String)s);
    }

    public static String getLinkLoginUrl(HttpServletRequest request) {
        return SeraphUtils.getLinkLoginURL(request);
    }

    public static String getLinkLoginPath(HttpServletRequest request) {
        return SeraphUtils.getLinkLoginURLAndStripContextPath(request);
    }

    public static List<Integer> intArrayToList(int[] array) {
        return Arrays.stream(array).boxed().toList();
    }
}

