/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.breadcrumbs;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.actions.SearchUsersAction;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.breadcrumbs.AbstractActionBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.AdminBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.SimpleBreadcrumb;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.List;

public class UserAdminActionBreadcrumb
extends AbstractActionBreadcrumb {
    private static final Breadcrumb SEARCH_USERS_CRUMB = new SimpleBreadcrumb("users.name", "/admin/users/browseusers.action");
    private final User user;

    public UserAdminActionBreadcrumb(ConfluenceActionSupport action, User user) {
        super(action);
        this.user = user;
    }

    @Override
    protected List<Breadcrumb> getMyCrumbs() {
        ArrayList<Breadcrumb> crumbs = new ArrayList<Breadcrumb>();
        if (!(this.action instanceof SearchUsersAction)) {
            crumbs.add(SEARCH_USERS_CRUMB);
        }
        if (this.user != null) {
            String name = this.user.getName();
            crumbs.add(new SimpleBreadcrumb(name, "/admin/users/viewuser.action?username=" + HtmlUtil.urlEncode(name)));
        }
        crumbs.add(this);
        return crumbs;
    }

    @Override
    public Breadcrumb getParent() {
        return AdminBreadcrumb.getInstance();
    }
}

