/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.longrunning;

import com.atlassian.annotations.nullability.FieldsAreNonnullByDefault;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.confluence.event.events.lifecycle.ApplicationStoppedEvent;
import com.atlassian.confluence.impl.event.RegisterEventListeners;
import com.atlassian.confluence.impl.util.concurrent.ConfluenceExecutors;
import com.atlassian.confluence.internal.diagnostics.LongRunningTaskMonitor;
import com.atlassian.confluence.internal.longrunning.LongRunningTaskManagerInternal;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.ManagedTask;
import com.atlassian.confluence.util.longrunning.TaskWrapper;
import com.atlassian.confluence.util.profiling.ActivityMonitor;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.ThreadFactories;
import jakarta.annotation.PreDestroy;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@RegisterEventListeners
public class DefaultLongRunningTaskManager
implements LongRunningTaskManagerInternal {
    private static final Logger lifecycleLog = LoggerFactory.getLogger((String)"com.atlassian.confluence.lifecycle");
    private static final long NOT_STARTED = 0L;
    private final ConcurrentMap<LongRunningTaskId, TaskWrapper> trackedTasks = new ConcurrentHashMap<LongRunningTaskId, TaskWrapper>();
    private volatile ExecutorService executorService;
    private final PermissionManager permissionManager;
    private final ActivityMonitor activityMonitor;
    private final LongRunningTaskMonitor longRunningTaskMonitor;

    public DefaultLongRunningTaskManager(PermissionManager permissionManager, ActivityMonitor activityMonitor, LongRunningTaskMonitor longRunningTaskMonitor) {
        this(permissionManager, activityMonitor, longRunningTaskMonitor, ConfluenceExecutors.wrap(DefaultLongRunningTaskManager.newThreadPoolExecutor(), ConfluenceExecutors.THREAD_LOCAL_CONTEXT_TASK_WRAPPER));
    }

    @VisibleForTesting
    DefaultLongRunningTaskManager(PermissionManager permissionManager, ActivityMonitor activityMonitor, LongRunningTaskMonitor longRunningTaskMonitor, ExecutorService executor) {
        this.permissionManager = Objects.requireNonNull(permissionManager);
        this.activityMonitor = Objects.requireNonNull(activityMonitor);
        this.longRunningTaskMonitor = Objects.requireNonNull(longRunningTaskMonitor);
        this.executorService = Objects.requireNonNull(executor);
    }

    @EventListener
    public void onApplicationStopped(ApplicationStoppedEvent e) {
        this.destroy(30L, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    static ThreadPoolExecutor newThreadPoolExecutor() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)"long-running-task", (ThreadFactories.Type)ThreadFactories.Type.USER));
    }

    @Override
    public void startIfQueued(LongRunningTaskId taskId) {
        Objects.requireNonNull(taskId, "taskId cannot be null");
        TaskWrapper taskWrapper = (TaskWrapper)this.trackedTasks.get(taskId);
        if (taskWrapper != null && taskWrapper.getStarted() == 0L) {
            if (this.executorService.isShutdown()) {
                throw new IllegalStateException("Unable to queue long-running task. Task manager has been stopped");
            }
            this.executorService.submit(new ManagedTask(taskId, taskWrapper.getTask(), this, this.activityMonitor));
            this.trackedTasks.put(taskId, new TaskWrapper(null, taskId, taskWrapper.getTask(), System.currentTimeMillis()));
        }
    }

    @Override
    public LongRunningTaskId startLongRunningTask(@Nullable ConfluenceUser user, LongRunningTask task) {
        ManagedTask wrappedTask = this.wrapAsManagedTask(user, task);
        this.executorService.submit(wrappedTask);
        return wrappedTask.getId();
    }

    @Override
    public void runToCompletion(@Nullable ConfluenceUser user, LongRunningTask task) {
        ManagedTask wrappedTask = this.wrapAsManagedTask(user, task);
        wrappedTask.run();
    }

    private ManagedTask wrapAsManagedTask(@Nullable ConfluenceUser user, LongRunningTask task) {
        Objects.requireNonNull(task, "task cannot be null");
        if (this.executorService.isShutdown()) {
            throw new IllegalStateException("Unable to queue long-running task. Task manager has been stopped");
        }
        LongRunningTaskId id = LongRunningTaskId.newInstance();
        ManagedTask wrappedTask = new ManagedTask(id, task, this, this.activityMonitor);
        this.longRunningTaskMonitor.start(task);
        this.trackedTasks.put(id, new TaskWrapper(user, id, task, System.currentTimeMillis()));
        return wrappedTask;
    }

    @Override
    public @Nullable LongRunningTask getLongRunningTask(@Nullable ConfluenceUser user, LongRunningTaskId taskId) {
        Objects.requireNonNull(taskId, "taskId cannot be null");
        TaskWrapper wrapper = (TaskWrapper)this.trackedTasks.get(taskId);
        if (wrapper != null && this.userCanGetTask(user, wrapper)) {
            return wrapper.getTask();
        }
        return null;
    }

    private boolean userCanGetTask(@Nullable ConfluenceUser user, TaskWrapper wrapper) {
        ConfluenceUser taskUser = wrapper.getUser();
        if (taskUser == null || wrapper.isSameUser(user)) {
            return true;
        }
        if (this.permissionManager.isSystemAdministrator(user)) {
            return true;
        }
        if (this.permissionManager.isConfluenceAdministrator(user)) {
            return !this.permissionManager.isSystemAdministrator(taskUser);
        }
        return false;
    }

    @Override
    public Map<LongRunningTaskId, LongRunningTask> getAllTasks(@Nullable ConfluenceUser asUser) {
        return this.trackedTasks.entrySet().stream().filter(entry -> this.userCanGetTask(asUser, (TaskWrapper)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((TaskWrapper)entry.getValue()).getTask()));
    }

    @Override
    public int getTaskCount() {
        return (int)this.trackedTasks.values().stream().filter(t -> !t.getTask().isComplete()).count();
    }

    @Override
    public void stopTrackingLongRunningTask(LongRunningTaskId taskId) {
        Objects.requireNonNull(taskId, "taskId cannot be null");
        this.trackedTasks.remove(taskId);
    }

    @PreDestroy
    public synchronized void destroy() {
        this.destroy(30L, TimeUnit.SECONDS);
    }

    private synchronized void destroy(long timeout, TimeUnit unit) {
        lifecycleLog.info("Shutting down long running task service");
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(timeout, unit)) {
                lifecycleLog.warn("Long running task service took more than {} {} to shutdown. Killing any remaining tasks.", (Object)timeout, (Object)unit);
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public synchronized void stop(long timeout, TimeUnit unit) throws TimeoutException {
        Objects.requireNonNull(unit, "unit cannot be null");
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(timeout, unit)) {
                this.resume();
                throw new TimeoutException("Unable to shut down LongRunningTask service in " + timeout + " " + String.valueOf((Object)unit));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public synchronized void resume() {
        this.executorService = ConfluenceExecutors.wrap(DefaultLongRunningTaskManager.newThreadPoolExecutor(), ConfluenceExecutors.THREAD_LOCAL_CONTEXT_TASK_WRAPPER);
    }

    protected void taskFinished(LongRunningTaskId taskId) {
        Objects.requireNonNull(taskId, "taskId cannot be null");
        TaskWrapper oldTaskWrapper = (TaskWrapper)this.trackedTasks.get(taskId);
        if (oldTaskWrapper != null) {
            TaskWrapper completedTaskWrapper = new TaskWrapper(oldTaskWrapper, System.currentTimeMillis());
            this.trackedTasks.replace(taskId, oldTaskWrapper, completedTaskWrapper);
            this.longRunningTaskMonitor.stop(oldTaskWrapper.getTask());
        }
    }
}

