/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.profiling;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.profiling.Activity;
import com.atlassian.confluence.util.profiling.ActivityMonitor;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
public class ConfluenceActivityFilter
implements Filter {
    private final ActivityMonitor activityMonitor;

    public ConfluenceActivityFilter(ActivityMonitor activityMonitor) {
        this.activityMonitor = activityMonitor;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String userId = this.generateUserId((HttpServletRequest)request);
        String summary = this.generateActivitySummary((HttpServletRequest)request);
        try (Activity activity = this.activityMonitor.registerStart(userId, "web-request", summary);){
            chain.doFilter(request, response);
        }
    }

    private String generateUserId(HttpServletRequest request) {
        String username = request.getRemoteUser();
        return StringUtils.isBlank((CharSequence)username) ? "<unknown>" : username;
    }

    private String generateActivitySummary(HttpServletRequest request) {
        String stripped = GeneralUtil.getOriginalPath(request);
        String queryStr = request.getQueryString();
        Object result = StringUtils.isNotBlank((CharSequence)queryStr) ? stripped + "?" + queryStr : stripped;
        return result;
    }
}

