/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.profiling;

import com.atlassian.confluence.util.profiling.ConfluenceMonitoringNameGenerationRule;
import java.util.List;

public class ConfluenceMonitoringNameGenerationParser {
    private static final String LABEL_TAG_NAME = "label.tag";
    private static final String USER_SPACE_NAME = "display.[userspace]";
    private static final ConfluenceMonitoringNameGenerationRule PREFIX_STRATEGY = ConfluenceMonitoringNameGenerationRule.getNameGenerationStrategy("^/(s|x|display/[^~/][^/]*|download|images|labels/[^/]+|plugins/servlet/[^/]+|questions|rest/[^/]+/[^/]+|rpc/trackback)(:?/.*|)");
    private static final ConfluenceMonitoringNameGenerationRule USER_SPACE_STRATEGY = ConfluenceMonitoringNameGenerationRule.getNameGenerationStrategy("^/display/~[^/]+(|/.*)", "display.[userspace]");
    private static final ConfluenceMonitoringNameGenerationRule LABEL_STRATEGY = ConfluenceMonitoringNameGenerationRule.getNameGenerationStrategy("^/label(?:/[A-Za-z0-9_-]+)?/[A-Za-z0-9_-]+(?:\\+[A-Za-z0-9_-]+)*$", "label.tag");
    private static final List<ConfluenceMonitoringNameGenerationRule> customNameGenerationStrategies = List.of(USER_SPACE_STRATEGY, LABEL_STRATEGY);

    public static String parseRequestUriForMonitoringName(String uri) {
        String result = PREFIX_STRATEGY.generateName(uri);
        if (!result.equals(uri)) {
            return result;
        }
        return customNameGenerationStrategies.stream().map(strategy -> strategy.generateName(uri)).filter(name -> !name.equals(uri)).findFirst().orElse(uri);
    }
}

