/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.profiling;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfluenceMonitoringNameGenerationRule {
    private static final String NAME_SUFFIX = ".%";
    private Pattern patternToMatch;
    private String nameToGenerate;
    private boolean isDefaultNameToGenerate = false;

    public ConfluenceMonitoringNameGenerationRule(String regex) {
        this.patternToMatch = Pattern.compile(regex, 2);
        this.isDefaultNameToGenerate = true;
    }

    public ConfluenceMonitoringNameGenerationRule(String regex, String nameToGenerate) {
        this.patternToMatch = Pattern.compile(regex, 2);
        this.nameToGenerate = nameToGenerate;
    }

    public ConfluenceMonitoringNameGenerationRule(Pattern patternToMatch) {
        this.patternToMatch = patternToMatch;
        this.isDefaultNameToGenerate = true;
    }

    public ConfluenceMonitoringNameGenerationRule(Pattern pattern, String nameToGenerate) {
        this.patternToMatch = pattern;
        this.nameToGenerate = nameToGenerate;
    }

    public String generateName(String input) {
        String generatedName = null;
        Matcher matcherResult = this.patternToMatch.matcher(input);
        if (matcherResult.matches()) {
            generatedName = this.isDefaultNameToGenerate ? matcherResult.group(1) : this.getNameToGenerate();
        }
        return generatedName == null ? input : this.formatName(generatedName);
    }

    private String formatName(String name) {
        return String.format("%s%s", name, NAME_SUFFIX);
    }

    private String getNameToGenerate() {
        return this.nameToGenerate;
    }

    public static ConfluenceMonitoringNameGenerationRule getNameGenerationStrategy(String regex) {
        return new ConfluenceMonitoringNameGenerationRule(regex);
    }

    public static ConfluenceMonitoringNameGenerationRule getNameGenerationStrategy(String regex, String nameToGenerate) {
        return new ConfluenceMonitoringNameGenerationRule(regex, nameToGenerate);
    }
}

