/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.profiling;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.impl.logging.admin.LoggingConfigService;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.util.profiling.filters.RequestProfilingFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;

@UnrestrictedAccess
public class ConfluenceProfilingFilter
extends RequestProfilingFilter {
    private final Supplier<LoggingConfigService> loggingConfigServiceRef = MemoizingComponentReference.containerComponent("loggingConfigService");
    private boolean isProfilingPerRequestEnabled;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (ContainerManager.isContainerSetup()) {
            this.isProfilingPerRequestEnabled = false;
            Optional.ofNullable(this.loggingConfigServiceRef.get()).ifPresent(service -> {
                this.isProfilingPerRequestEnabled = service.isPerRequestLoggingEnabled();
            });
            if (this.isProfilingPerRequestEnabled) {
                this.callSuperDoFilter(request, response, chain);
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    @VisibleForTesting
    void callSuperDoFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        super.doFilter(request, response, chain);
    }
}

