/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.profiling;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@ParametersAreNonnullByDefault
@Internal
public class DurationThresholdWarningTimingHelper {
    private static final Logger log = LoggerFactory.getLogger(DurationThresholdWarningTimingHelper.class);
    private final WarnLog warnLog;
    private final Duration optionalWarningThreshold;
    private final Ticker ticker;
    private static final Timer NO_OP_TIMER = new Timer(){

        @Override
        public Timer start() {
            return this;
        }

        @Override
        public void stopAndCheckTiming() {
        }
    };

    DurationThresholdWarningTimingHelper(@Nullable Duration warningThreshold, Ticker ticker, WarnLog warnLog) {
        this.warnLog = Objects.requireNonNull(warnLog);
        this.ticker = Objects.requireNonNull(ticker);
        this.optionalWarningThreshold = warningThreshold;
    }

    @VisibleForTesting
    Duration getWarningThreshold() {
        return this.optionalWarningThreshold;
    }

    public Timer newDescribedTimer(Supplier<String> actionDescriptionSupplier, boolean disableWarnings) {
        if (disableWarnings || this.optionalWarningThreshold == null) {
            log.debug("Returning no-op timer");
            return NO_OP_TIMER;
        }
        log.debug("Returning warning timer");
        return new WarningTimer(actionDescriptionSupplier);
    }

    public Timer newWarningTimer(String actionDescriptionFormat, Object ... actionDescriptionArgs) {
        return this.newDescribedTimer(() -> String.format(actionDescriptionFormat, actionDescriptionArgs), false);
    }

    private void checkElapsedTimeAndWarnIfThresholdExceeded(long elapsedMillis, Supplier<String> actionDescriptionSupplier) {
        long thresholdMillis = this.optionalWarningThreshold.toMillis();
        if (elapsedMillis > thresholdMillis) {
            if (this.warnLog.isLogEnabled()) {
                this.warnLog.logMessage("Execution time for {} took {} ms (warning threshold is {} ms)", actionDescriptionSupplier.get(), elapsedMillis, thresholdMillis);
            } else if (log.isDebugEnabled()) {
                log.debug("Execution time for {} took {} ms (warning threshold is {} ms)", new Object[]{actionDescriptionSupplier.get(), elapsedMillis, thresholdMillis});
            }
        }
    }

    @VisibleForTesting
    static interface WarnLog {
        public boolean isLogEnabled();

        public void logMessage(String var1, Object ... var2);
    }

    @NotThreadSafe
    public static interface Timer {
        public Timer start();

        public void stopAndCheckTiming();
    }

    private class WarningTimer
    implements Timer {
        private final Stopwatch stopwatch;
        private final Supplier<String> actionDescriptionSupplier;

        public WarningTimer(Supplier<String> actionDescriptionSupplier) {
            this.stopwatch = Stopwatch.createUnstarted((Ticker)DurationThresholdWarningTimingHelper.this.ticker);
            this.actionDescriptionSupplier = actionDescriptionSupplier;
        }

        @Override
        public Timer start() {
            this.stopwatch.reset().start();
            return this;
        }

        @Override
        public void stopAndCheckTiming() {
            DurationThresholdWarningTimingHelper.this.checkElapsedTimeAndWarnIfThresholdExceeded(this.stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), this.actionDescriptionSupplier);
        }
    }
}

