/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.profiling;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.util.profiling.DurationThresholdWarningTimingHelper;
import com.google.common.base.Ticker;
import java.time.Duration;
import net.jcip.annotations.ThreadSafe;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@ParametersAreNonnullByDefault
@Internal
public class DurationThresholdWarningTimingHelperFactory {
    private static final Logger log = LoggerFactory.getLogger(DurationThresholdWarningTimingHelperFactory.class);
    private static final DurationThresholdWarningTimingHelper.WarnLog SLF4J = new DurationThresholdWarningTimingHelper.WarnLog(){

        @Override
        public boolean isLogEnabled() {
            return log.isWarnEnabled();
        }

        @Override
        public void logMessage(String format, Object ... args) {
            log.warn(format, args);
        }
    };

    public static DurationThresholdWarningTimingHelper createFromSystemProperty(String millisPropertyName, @Nullable Duration defaultThreshold) {
        String propertyValue = System.getProperty(millisPropertyName);
        if (propertyValue == null) {
            if (defaultThreshold == null) {
                log.debug("Creating helper with warning threshold disabled by default since sysprop {} was not defined", (Object)millisPropertyName);
                return DurationThresholdWarningTimingHelperFactory.createDisabled();
            }
            log.debug("Creating helper with default warning threshold of {} since sysprop {} was not defined", (Object)defaultThreshold, (Object)millisPropertyName);
            return DurationThresholdWarningTimingHelperFactory.create(defaultThreshold);
        }
        int thresholdMillis = Integer.parseInt(propertyValue);
        if (thresholdMillis > 0) {
            Duration threshold = Duration.ofMillis(thresholdMillis);
            log.debug("Creating helper with configured warning threshold of {} from sysprop {}", (Object)threshold, (Object)millisPropertyName);
            return DurationThresholdWarningTimingHelperFactory.create(threshold);
        }
        log.debug("Creating helper with warning threshold disabled by sysprop {}", (Object)millisPropertyName);
        return DurationThresholdWarningTimingHelperFactory.createDisabled();
    }

    private static DurationThresholdWarningTimingHelper create(Duration warningThreshold) {
        return new DurationThresholdWarningTimingHelper(warningThreshold, Ticker.systemTicker(), SLF4J);
    }

    private static DurationThresholdWarningTimingHelper createDisabled() {
        return new DurationThresholdWarningTimingHelper(null, Ticker.systemTicker(), SLF4J);
    }
}

