/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.velocity;

import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.cache.CoreCache;
import com.atlassian.confluence.setup.velocity.DecoratorName;
import com.atlassian.confluence.util.velocity.ConfluenceVelocityResourceCache;
import com.atlassian.confluence.util.velocity.ConfluenceVelocityTemplateImpl;
import com.atlassian.confluence.util.velocity.ResourceLoaderWrapper;
import com.atlassian.confluence.velocity.ConfigurableResourceManager;
import java.io.InputStream;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.ContentResource;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceVelocityResourceManager
extends ConfigurableResourceManager {
    private static final Logger privateLog = LoggerFactory.getLogger(ConfluenceVelocityResourceManager.class);
    private static ConfluenceVelocityResourceManager instance;
    private static final ConfigurableResourceManager.ResourceFactory RESOURCE_FACTORY;
    private static CacheFactory cacheFactory;

    public ConfluenceVelocityResourceManager() {
        instance = this;
    }

    public static void setCacheFactory(CacheFactory cacheFactory) {
        ConfluenceVelocityResourceManager.cacheFactory = cacheFactory;
        if (instance != null) {
            instance.initConfluenceVelocityCache();
        }
    }

    public void initialize(RuntimeServices runtimeServices) throws Exception {
        super.initialize(runtimeServices);
        this.initConfluenceVelocityCache();
    }

    private synchronized void initConfluenceVelocityCache() {
        if (cacheFactory == null) {
            privateLog.debug("No cache manager. Using default resource cache");
            return;
        }
        privateLog.debug("Initializing ConfluenceVelocityResourceCache");
        this.globalCache = new ConfluenceVelocityResourceCache(CoreCache.VELOCITY_RESOURCES.getCache(cacheFactory));
        this.globalCache.initialize(this.rsvc);
    }

    protected ResourceLoader postProcessLoader(ResourceLoader loader, ExtendedProperties config) {
        if (!config.getBoolean("confluence.space.decorator.loader", false)) {
            loader = new DecoratorFilteredResourceLoader(loader);
        }
        return super.postProcessLoader(loader, config);
    }

    protected ConfigurableResourceManager.ResourceFactory getResourceFactory() {
        return RESOURCE_FACTORY;
    }

    static {
        RESOURCE_FACTORY = new ConfluenceResourceFactory();
    }

    private static class DecoratorFilteredResourceLoader
    extends ResourceLoaderWrapper {
        public DecoratorFilteredResourceLoader(ResourceLoader loader) {
            super(loader);
        }

        @Override
        public final InputStream getResourceStream(String s) throws ResourceNotFoundException {
            if (DecoratorName.isSpaceDecoratorSource(s)) {
                return null;
            }
            return super.getResourceStream(s);
        }
    }

    public static class ConfluenceResourceFactory
    implements ConfigurableResourceManager.ResourceFactory {
        public Resource getResource(String resourceName, int resourceType) {
            ConfluenceVelocityTemplateImpl resource = null;
            switch (resourceType) {
                case 1: {
                    resource = new ConfluenceVelocityTemplateImpl();
                    break;
                }
                case 2: {
                    resource = new ContentResource();
                    break;
                }
            }
            return resource;
        }
    }
}

