/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.zip;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.gzipfilter.integration.GzipFilterIntegration;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public class ConfluenceGzipFilterIntegration
implements GzipFilterIntegration {
    private static final boolean USE_GZIP_DEFAULT = false;
    private static final Charset ENCODING_DEFAULT = StandardCharsets.UTF_8;
    private final Supplier<GlobalSettingsManager> settingsManager = MemoizingComponentReference.containerComponent("globalSettingsManager");
    private final BooleanSupplier isReady;

    public ConfluenceGzipFilterIntegration() {
        this(GeneralUtil::isReadyToServe);
    }

    @VisibleForTesting
    ConfluenceGzipFilterIntegration(BooleanSupplier isReady) {
        this.isReady = isReady;
    }

    public boolean useGzip() {
        return this.isReady.getAsBoolean() ? this.settingsManager.get().getGlobalSettings().isGzippingResponse() : false;
    }

    public String getResponseEncoding(HttpServletRequest request) {
        return this.isReady.getAsBoolean() ? this.settingsManager.get().getGlobalSettings().getDefaultEncoding() : ENCODING_DEFAULT.name();
    }
}

