/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.validation;

import com.atlassian.confluence.setup.SetupContext;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.confluence.validation.MessageHolder;
import com.atlassian.confluence.validation.MessageHolderAware;
import com.atlassian.confluence.validation.MessageHolderFactory;
import com.atlassian.confluence.validation.MessageLoadingPreResultListener;
import com.atlassian.spring.container.ContainerManager;
import java.util.function.Supplier;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.interceptor.Interceptor;

public class MessageHolderInterceptor
implements Interceptor {
    private final Supplier<MessageHolderFactory> holderFactory = MemoizingComponentReference.containerComponent("messageHolderFactory");

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation actionInvocation) throws Exception {
        Object object = actionInvocation.getAction();
        if (object instanceof MessageHolderAware) {
            MessageHolderAware holderAware = (MessageHolderAware)object;
            if (this.getMessageHolderFactory() != null) {
                MessageHolder holder = this.getMessageHolderFactory().newHolder();
                holderAware.setMessageHolder(holder);
                actionInvocation.addPreResultListener(MessageLoadingPreResultListener.getInstance());
            }
        }
        return actionInvocation.invoke();
    }

    private MessageHolderFactory getMessageHolderFactory() {
        if (!ContainerManager.isContainerSetup()) {
            if (SetupContext.get() != null) {
                return (MessageHolderFactory)SetupContext.get().getBean("messageHolderFactory");
            }
            return null;
        }
        return this.holderFactory.get();
    }
}

