/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.impl.tenant.ThreadLocalTenantGate;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.filters.JohnsonFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ConfluenceJohnsonFilter
extends JohnsonFilter {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceJohnsonFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.fullPathIgnored((HttpServletRequest)servletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            super.doFilter(servletRequest, servletResponse, filterChain);
        }
    }

    protected void handleError(JohnsonEventContainer appEventContainer, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String servletPath = ConfluenceJohnsonFilter.getServletPath((HttpServletRequest)servletRequest);
        log.info("The application is still starting up, or there are errors. Redirecting request from '{}' to '{}'", (Object)servletPath, (Object)this.config.getErrorPath());
        if (servletRequest.getMethod().equalsIgnoreCase("GET")) {
            servletResponse.setStatus(503);
            try {
                ThreadLocalTenantGate.withTenantPermit(() -> {
                    servletRequest.getRequestDispatcher(this.config.getErrorPath()).forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                    return null;
                }).call();
                return;
            }
            catch (Exception e) {
                log.error("Unable to forward request to {}. Performing a redirect instead.", (Object)this.config.getErrorPath(), (Object)e);
            }
        }
        String contextPath = servletRequest.getContextPath();
        servletResponse.sendRedirect(contextPath + this.config.getErrorPath());
    }

    private boolean fullPathIgnored(HttpServletRequest request) {
        String fullPath = StringUtils.defaultString((String)request.getServletPath()) + StringUtils.defaultString((String)request.getPathInfo());
        return this.config.isIgnoredPath(fullPath);
    }
}

