/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web;

import com.atlassian.confluence.plugin.descriptor.web.ConfluenceWebInterfaceManager;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.web.WebMenu;
import com.atlassian.confluence.web.WebMenuManager;
import com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.api.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebFragmentModuleDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ConfluenceWebMenuManager
implements WebMenuManager {
    protected final ConfluenceWebInterfaceManager webInterfaceManager;

    public ConfluenceWebMenuManager(ConfluenceWebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    @Override
    public WebMenu getMenu(String id, String menuKey, WebInterfaceContext context) {
        return this.getMenu(id, Collections.singleton(menuKey), context);
    }

    @Override
    public WebMenu getMenu(String id, Collection<String> menuKeys, WebInterfaceContext context) {
        WebMenu menu = new WebMenu(id);
        for (String menuKey : menuKeys) {
            menu.addSection("leading", null, null, this.getLeadingItems(menuKey, context));
            for (WebSectionModuleDescriptor webSectionModuleDescriptor : this.getSections(menuKey, context)) {
                WebFragmentModuleDescriptor castSection = (WebFragmentModuleDescriptor)webSectionModuleDescriptor;
                String label = castSection.getWebLabel() == null ? "" : castSection.getWebLabel().getKey();
                String ariaLabel = webSectionModuleDescriptor.getParams() == null ? "" : (String)webSectionModuleDescriptor.getParams().get("ariaLabelKey");
                menu.addSection(webSectionModuleDescriptor.getKey(), label, ariaLabel, this.getSectionItems(menuKey, webSectionModuleDescriptor.getKey(), context));
            }
            menu.addSection("trailing", "", null, this.getTrailingItems(menuKey, context));
        }
        return menu;
    }

    protected List<? extends WebItemModuleDescriptor> getSectionItems(String menuKey, String sectionKey, WebInterfaceContext context) {
        return this.webInterfaceManager.getDisplayableItems(menuKey + "/" + sectionKey, context);
    }

    protected List<? extends WebSectionModuleDescriptor> getSections(String menuKey, WebInterfaceContext context) {
        return this.webInterfaceManager.getDisplayableSections(menuKey, context);
    }

    protected List<WebItemModuleDescriptor> getTrailingItems(String menuKey, WebInterfaceContext context) {
        return Collections.emptyList();
    }

    protected List<? extends WebItemModuleDescriptor> getLeadingItems(String menuKey, WebInterfaceContext context) {
        return this.webInterfaceManager.getDisplayableItems(menuKey, context);
    }
}

