/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web;

import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.seraph.config.SecurityConfigFactory;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Objects;

public final class Cookies {
    public static Cookie setResponseCookie(String key, String value) {
        StaticHttpContext staticContext = new StaticHttpContext();
        HttpServletRequest request = staticContext.getActiveRequest();
        HttpServletResponse response = staticContext.getActiveResponse();
        int cookieAge = 31104000;
        return Cookies.setResponseCookie(request, response, key, value, cookieAge, Objects.toString(request.getContextPath(), "/"));
    }

    private static Cookie setResponseCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge, String path) {
        boolean isInsecureCookie = SecurityConfigFactory.getInstance().isInsecureCookie();
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath(path);
        if (!isInsecureCookie) {
            cookie.setSecure(request.isSecure());
        }
        response.addCookie(cookie);
        return cookie;
    }

    public static String getCookieValue(HttpServletRequest request, String key) {
        if (request.getCookies() == null || key == null || key.isEmpty()) {
            return null;
        }
        return Arrays.stream(request.getCookies()).filter(cookie -> cookie.getName().equals(key)).findFirst().map(Cookie::getValue).orElse(null);
    }

    public static String getCookieValue(String key) {
        return Cookies.getCookieValue(new StaticHttpContext().getActiveRequest(), key);
    }
}

