/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.context;

import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.core.filters.ServletContextThreadLocal;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.apache.struts2.ActionContext;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticHttpContext
implements HttpContext {
    private static final Logger log = LoggerFactory.getLogger(StaticHttpContext.class);

    @Override
    public HttpServletRequest getActiveRequest() {
        if (ActionContext.getContext() != null && ServletActionContext.getRequest() != null) {
            log.debug("Using ServletActionContext request");
            return ServletActionContext.getRequest();
        }
        log.debug("Using ServletContextThreadLocal request");
        return ServletContextThreadLocal.getRequest();
    }

    @Override
    public HttpServletResponse getActiveResponse() {
        if (ActionContext.getContext() != null && ServletActionContext.getResponse() != null) {
            log.debug("Using ServletActionContext response");
            return ServletActionContext.getResponse();
        }
        log.debug("Using ServletContextThreadLocal response");
        return ServletContextThreadLocal.getResponse();
    }

    @Override
    public HttpSession getActiveSession(boolean create) {
        HttpServletRequest request = this.getActiveRequest();
        if (request == null) {
            return null;
        }
        return request.getSession(create);
    }
}

