/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.filter;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.internal.health.JohnsonEventLevel;
import com.atlassian.confluence.internal.health.JohnsonEventPredicates;
import com.atlassian.johnson.Johnson;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.filter.SecurityFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ConfluenceSecurityFilter
extends SecurityFilter {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceSecurityFilter.class);
    static final String ALREADY_FILTERED = "os_securityfilter_already_filtered";

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.bypassFilter()) {
            chain.doFilter(req, res);
        } else {
            this.applyFilter(req, res, chain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void applyFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Object previousAlreadyFiltered = req.getAttribute(ALREADY_FILTERED);
        req.setAttribute(ALREADY_FILTERED, null);
        Principal existingUser = this.getAuthenticationContext().getUser();
        if (existingUser != null && log.isDebugEnabled()) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpSession session = request.getSession(false);
            log.debug("Found existing user {} in AuthenticationContext in session {} for request {}", new Object[]{existingUser, session == null ? null : session.getId(), request.getPathInfo()});
        }
        try {
            super.doFilter(req, res, chain);
        }
        finally {
            if (log.isDebugEnabled() && existingUser != null) {
                log.debug("Resetting user in AuthenticationContext back to {}, previous value was {}", (Object)existingUser, (Object)this.getAuthenticationContext().getUser());
            }
            this.getAuthenticationContext().setUser(existingUser);
            req.setAttribute(ALREADY_FILTERED, previousAlreadyFiltered);
        }
    }

    @VisibleForTesting
    boolean bypassFilter() {
        return Johnson.getEventContainer().hasEvent(JohnsonEventPredicates.hasLevel((JohnsonEventLevel)JohnsonEventLevel.FATAL));
    }

    @VisibleForTesting
    protected SecurityConfig getSecurityConfig() {
        return super.getSecurityConfig();
    }
}

