/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.util.DefaultClock;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.Clock;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

@UnrestrictedAccess
public class ConfluenceTimeoutFilter
extends HttpFilter {
    static final String SESSION_TIMESTAMP = "confluence.security.timestamp";
    static final PathMatcher PATH_MATCHER = new AntPathMatcher();
    final Clock clock;
    Iterable<String> urlsToExclude;

    public ConfluenceTimeoutFilter() {
        this((Clock)new DefaultClock());
    }

    public ConfluenceTimeoutFilter(Clock clock) {
        this.clock = clock;
    }

    public void init(FilterConfig config) throws ServletException {
        String urlPatternsToExcludeSessionExtension = config.getInitParameter("urlPatternsToExclude");
        this.urlsToExclude = urlPatternsToExcludeSessionExtension == null ? Collections.emptyList() : Splitter.on((char)',').trimResults().split((CharSequence)urlPatternsToExcludeSessionExtension);
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            this.renewSessionTimeoutIfNeeded(request, session);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void renewSessionTimeoutIfNeeded(HttpServletRequest request, HttpSession session) {
        Long sessionTimestamp = (Long)session.getAttribute(SESSION_TIMESTAMP);
        long currentTime = this.clock.getCurrentDate().getTime();
        if (sessionTimestamp == null) {
            session.setAttribute(SESSION_TIMESTAMP, (Object)currentTime);
            return;
        }
        long sessionLife = TimeUnit.SECONDS.toMillis(session.getMaxInactiveInterval());
        if (currentTime >= sessionTimestamp + sessionLife) {
            session.invalidate();
            return;
        }
        String requestURI = GeneralUtil.getOriginalPath(request);
        boolean matched = Iterables.any(this.urlsToExclude, input -> PATH_MATCHER.match(input, requestURI));
        if (!matched) {
            session.setAttribute(SESSION_TIMESTAMP, (Object)currentTime);
        }
    }
}

