/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.util.profiling.ConfluenceMonitoring;
import com.atlassian.confluence.util.profiling.ConfluenceMonitoringNameGenerator;
import com.atlassian.confluence.util.profiling.Split;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

@UnrestrictedAccess
public class ConfluenceTimingFilter
implements Filter {
    private final ConfluenceMonitoring performanceMonitor;
    private String prefix = "<TBD>";

    public ConfluenceTimingFilter(ConfluenceMonitoring perfMonitor) {
        this.performanceMonitor = perfMonitor;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.prefix = (String)StringUtils.defaultIfBlank((CharSequence)StringUtils.stripToEmpty((String)filterConfig.getInitParameter("prefix")), (CharSequence)"URI");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try (Split ignored = this.startTimer((HttpServletRequest)request);){
            chain.doFilter(request, response);
        }
    }

    private @NonNull Split startTimer(HttpServletRequest request) {
        return this.performanceMonitor.startSplit(this.prefix, Collections.singletonMap("pathPattern", ConfluenceMonitoringNameGenerator.generateName(request)));
    }
}

