/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.event.events.analytics.HttpRequestStats;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.instrumentation.driver.Instrumentation;
import com.atlassian.instrumentation.instruments.Context;
import com.atlassian.instrumentation.instruments.EventType;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class HttpRequestStatsFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestStatsFilter.class);
    private final Instrumentation.SplitFactory splitFactory;
    private final EventPublisher eventPublisher;

    public HttpRequestStatsFilter(EventPublisher eventPublisher) {
        this(eventPublisher, Clock.systemUTC());
    }

    @VisibleForTesting
    HttpRequestStatsFilter(EventPublisher eventPublisher, Clock clock) {
        this.eventPublisher = eventPublisher;
        this.splitFactory = new SplitFactory(clock);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Instrumentation.registerFactory((Instrumentation.SplitFactory)this.splitFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpRequestStats.start((HttpServletRequest)request);
        try {
            chain.doFilter(request, response);
        }
        finally {
            HttpRequestStats.stop().ifPresent(arg_0 -> ((EventPublisher)this.eventPublisher).publish(arg_0));
        }
    }

    public void destroy() {
        Instrumentation.unregisterFactory((Instrumentation.SplitFactory)this.splitFactory);
    }

    private static class SplitFactory
    implements Instrumentation.SplitFactory {
        private final Clock clock;

        SplitFactory(Clock clock) {
            this.clock = clock;
        }

        public Instrumentation.Split startSplit(Context context) {
            return context.getEventType().filter(et -> et == EventType.EXECUTION).map(eventType -> {
                log.trace("Executed SQL: {}", (Object)context.getSql());
                Instant beforeOperation = Instant.now(this.clock);
                return () -> HttpRequestStats.logDbRequest(Duration.between(beforeOperation, Instant.now(this.clock)));
            }).orElse(() -> {});
        }
    }
}

