/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.confluence.util.UserAgentUtil;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.util.RedirectUtils;
import com.atlassian.spring.container.ContainerManager;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;

@UnrestrictedAccess
public final class HttpSessionRegistrarFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(HttpSessionRegistrarFilter.class);
    private final Supplier<SessionRegistry> registry = MemoizingComponentReference.containerComponent("sessionRegistry");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ContainerManager.isContainerSetup()) {
            chain.doFilter(request, response);
            return;
        }
        SecurityConfig config = SecurityConfigFactory.getInstance();
        if (!config.getController().isSecurityEnabled()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        HttpSession httpSession = httpServletRequest.getSession();
        SessionInformation sessionInformation = this.sessionRegistry().getSessionInformation(httpSession.getId());
        if (null != sessionInformation && sessionInformation.isExpired()) {
            try {
                config.getAuthenticator().logout(httpServletRequest, httpServletResponse);
            }
            catch (AuthenticatorException e) {
                log.info("Unable to logout user using configured authenticator, invalidating current http session and redirecting to login.");
                log.debug(e.getMessage());
                httpSession.invalidate();
            }
            finally {
                if (this.isMobileAppBrowserFamily(httpServletRequest)) {
                    httpServletResponse.setStatus(401);
                } else {
                    httpServletResponse.sendRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)httpServletRequest));
                }
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private SessionRegistry sessionRegistry() {
        return this.registry.get();
    }

    private boolean isMobileAppBrowserFamily(HttpServletRequest request) {
        UserAgentUtil.UserAgent userAgentInfo = UserAgentUtil.getUserAgentInfo((String)UserAgentUtil.getUserAgent((HttpServletRequest)request));
        UserAgentUtil.BrowserFamily browserFamily = userAgentInfo.getBrowser().getBrowserFamily();
        return UserAgentUtil.BrowserFamily.ATLASSIAN_MOBILE == browserFamily || UserAgentUtil.BrowserFamily.CONFLUENCE_MOBILE_APP == browserFamily;
    }
}

