/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.filter;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.confluence.web.Cookies;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

@UnrestrictedAccess
public class LanguageExtractionFilter
extends HttpFilter {
    private final BooleanSupplier isReadyToServe;
    private final BiFunction<HttpServletRequest, String, String> getCookieValue;
    private final Supplier<LocaleManager> localeManager;

    public LanguageExtractionFilter() {
        this(GeneralUtil::isReadyToServe, Cookies::getCookieValue, MemoizingComponentReference.containerComponent("localeManager"));
    }

    @VisibleForTesting
    LanguageExtractionFilter(BooleanSupplier isReadyToServe, BiFunction<HttpServletRequest, String, String> getCookieValue, Supplier<LocaleManager> localeManager) {
        this.isReadyToServe = isReadyToServe;
        this.getCookieValue = getCookieValue;
        this.localeManager = localeManager;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.isReadyToServe.getAsBoolean()) {
            Optional.ofNullable(this.getCookieValue.apply(request, "confluence-language")).ifPresent(cookieValue -> this.localeManager.get().setLanguage((String)cookieValue));
            Optional.ofNullable(request.getHeader("accept-language")).ifPresent(headerValue -> this.localeManager.get().setRequestLanguages((String)headerValue));
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

