/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.api.service.event.mau.MauEventService;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.confluence.web.filter.AbstractStaticResourceAwareFilter;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.function.Supplier;

@UnrestrictedAccess
public class MauEventFilter
extends AbstractStaticResourceAwareFilter {
    @VisibleForTesting
    static final String IGNORE_MAU_HEADER = "x-atlassian-mau-ignore";
    private final Supplier<MauEventService> mauEventServiceRef = MemoizingComponentReference.containerComponent("mauEventService");

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request.getHeader(IGNORE_MAU_HEADER) == null && ContainerManager.isContainerSetup()) {
            this.mauEventServiceRef.get().clearApplicationActivities();
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            this.mauEventServiceRef.get().sendMauEvents();
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

