/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.filter;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.web.filter.CachingHeaders;
import com.atlassian.core.filters.cache.CachingStrategy;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.net.URISyntaxException;

class PreventCachingStrategy
implements CachingStrategy {
    PreventCachingStrategy() {
    }

    public boolean matches(HttpServletRequest request) {
        String uri;
        try {
            uri = this.getNormalisedPathFrom(request);
        }
        catch (URISyntaxException invalidUriInRequest) {
            return true;
        }
        if (uri.contains("/rest/")) {
            return false;
        }
        return uri.equals("/") || uri.contains(".vm") || uri.contains(".action") || uri.contains("/display/");
    }

    private String getNormalisedPathFrom(HttpServletRequest request) throws URISyntaxException {
        String decodedUri = HtmlUtil.urlDecode(GeneralUtil.getOriginalPath(request));
        return new URI(decodedUri).normalize().toString();
    }

    public void setCachingHeaders(HttpServletResponse response) {
        CachingHeaders.PREVENT_CACHING.apply(response);
    }
}

