/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.NonNull;

@UnrestrictedAccess
public class ResponseOutputStreamFilter
extends HttpFilter {
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        NoopAfterCloseResponse wrappedResponse = new NoopAfterCloseResponse(response);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)wrappedResponse);
    }

    private static class NoopAfterCloseResponse
    extends HttpServletResponseWrapper {
        private ServletOutputStream wrappedOutputStream;

        private NoopAfterCloseResponse(HttpServletResponse response) throws IOException {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.wrappedOutputStream == null) {
                this.wrappedOutputStream = new NoopAfterCloseOutputStream(super.getOutputStream());
            }
            return this.wrappedOutputStream;
        }
    }

    private static class NoopAfterCloseOutputStream
    extends ServletOutputStream {
        private ServletOutputStream out;
        private volatile boolean closed = false;

        private NoopAfterCloseOutputStream(ServletOutputStream out) {
            this.out = out;
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.out.close();
            }
            finally {
                this.out = null;
            }
        }

        public void write(int b) throws IOException {
            if (this.closed) {
                return;
            }
            this.out.write(b);
        }

        public void write(@NonNull byte[] b) throws IOException {
            if (this.closed) {
                return;
            }
            this.out.write(b);
        }

        public void write(@NonNull byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                return;
            }
            this.out.write(b, off, len);
        }

        public void flush() throws IOException {
            if (this.closed) {
                return;
            }
            this.out.flush();
        }

        public boolean isReady() {
            if (this.closed) {
                return true;
            }
            return this.out.isReady();
        }

        public void setWriteListener(@NonNull WriteListener writeListener) {
            if (this.closed) {
                return;
            }
            this.out.setWriteListener(writeListener);
        }
    }
}

