/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.cache.ThreadLocalCache;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.security.csp.api.internal.NonceService;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.function.Supplier;

@UnrestrictedAccess
public class ThreadLocalCacheFilter
implements Filter {
    private final Supplier<NonceService> nonceServiceSupplier = MemoizingComponentReference.containerComponent("nonceService");
    private final boolean isCSPViolationLoggingEnabled = Boolean.getBoolean("enable.csp.violation.logging");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            ThreadLocalCache.init();
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            NonceService nonceService;
            ThreadLocalCache.dispose();
            if (this.isCSPViolationLoggingEnabled && this.isReadyToServe() && (nonceService = this.nonceServiceSupplier.get()) != null) {
                nonceService.clearNonce();
            }
        }
    }

    private boolean isReadyToServe() {
        return GeneralUtil.isReadyToServe();
    }

    public void destroy() {
    }
}

