/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.filter;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalCleanupFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ThreadLocalCleanupFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            this.validateAuthenticatedUserThreadLocal();
            filterChain.doFilter(request, response);
        }
        finally {
            this.resetAuthenticatedUserThreadLocal();
        }
    }

    private void validateAuthenticatedUserThreadLocal() {
        if (AuthenticatedUserThreadLocal.get() != null) {
            log.error("User {} is already present in authentication context in current thread, there is a chance of ThreadLocal leak if it's not reset properly", (Object)AuthenticatedUserThreadLocal.get());
        }
    }

    private void resetAuthenticatedUserThreadLocal() {
        if (log.isDebugEnabled()) {
            log.debug("Removing authenticated user {} from authentication context", (Object)AuthenticatedUserThreadLocal.get());
        }
        AuthenticatedUserThreadLocal.reset();
    }
}

