/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.filter;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.confluence.util.i18n.I18nModeManager;
import com.atlassian.confluence.util.i18n.TranslationMode;
import com.atlassian.core.filters.AbstractHttpFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

@UnrestrictedAccess
public class TranslationModeFilter
extends AbstractHttpFilter {
    static final String TRANSLATION_MODE_PARAM = "i18ntranslate";
    private final Supplier<I18nModeManager> i18nModeManager;
    private final BooleanSupplier isReadyToServe;

    public TranslationModeFilter() {
        this(MemoizingComponentReference.containerComponent("translationModeManager"), GeneralUtil::isReadyToServe);
    }

    @VisibleForTesting
    TranslationModeFilter(Supplier<I18nModeManager> i18nModeManager, BooleanSupplier isReadyToServe) {
        this.i18nModeManager = i18nModeManager;
        this.isReadyToServe = isReadyToServe;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.isReadyToServe.getAsBoolean()) {
            String translationModeParam = request.getParameter(TRANSLATION_MODE_PARAM);
            TranslationMode translationMode = this.i18nModeManager.get().getModeForString(translationModeParam);
            if (translationMode != null) {
                this.i18nModeManager.get().setTranslationMode(request, translationMode);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

