/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.filter;

import brave.http.HttpTracing;
import brave.jakarta.servlet.TracingFilter;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.spring.container.ContainerManager;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Objects;

@UnrestrictedAccess
@Internal
public class ZipkinTracingFilter
implements Filter {
    private FilterConfig filterConfig;
    private final ResettableLazyReference<Filter> tracingFilter = Lazy.resettableCallable(() -> {
        HttpTracing httpTracingReference = (HttpTracing)ContainerManager.getComponent((String)"httpTracing", HttpTracing.class);
        Filter filter = TracingFilter.create((HttpTracing)Objects.requireNonNull(httpTracingReference));
        filter.init(Objects.requireNonNull(this.filterConfig));
        return filter;
    });

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (ContainerManager.isContainerSetup()) {
            ((Filter)this.tracingFilter.get()).doFilter(servletRequest, servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
        if (this.tracingFilter.isInitialized()) {
            ((Filter)this.tracingFilter.get()).destroy();
            this.tracingFilter.reset();
        }
    }
}

