/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.service;

import com.atlassian.confluence.core.ContextPathHolder;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Proxy;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class FakeRequestFactory {
    private final ContextPathHolder contextPathHolder;

    @NonNull FakeRequestFactory(ContextPathHolder contextPathHolder) {
        this.contextPathHolder = contextPathHolder;
    }

    HttpServletRequest createFakeRequestUnlessNonNull(@Nullable HttpServletRequest request) {
        return request == null ? this.fakeRequest() : request;
    }

    private HttpServletRequest fakeRequest() {
        return this.proxySingleMethod(HttpServletRequest.class, "getContextPath", this.contextPathHolder.getContextPath());
    }

    private <T> T proxySingleMethod(Class<T> targetType, String methodName, Object returnValue) {
        return targetType.cast(Proxy.newProxyInstance(targetType.getClassLoader(), new Class[]{targetType}, (proxy, method, args) -> {
            if (method.equals(targetType.getMethod(methodName, new Class[0]))) {
                return returnValue;
            }
            throw new UnsupportedOperationException("Fake request is not implemented for method %s".formatted(method));
        }));
    }
}

