/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.service;

import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.confluence.content.datasource.DataSource;
import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.mail.embed.MimeBodyPartRecorder;
import com.atlassian.confluence.mail.embed.MimeBodyPartReference;
import com.atlassian.confluence.plugin.descriptor.web.descriptors.ConfluenceWebItemModuleDescriptor;
import com.atlassian.confluence.web.service.EmbeddedResourceParamRecordingPredicate;
import com.atlassian.plugin.ModuleCompleteKey;
import io.atlassian.fugue.Pair;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RecordIconMimeBodyPartFunction
implements Function<DataSourceFactory, Iterable<Pair<Icon, Optional<MimeBodyPartReference>>>> {
    private static final Logger log = LoggerFactory.getLogger(RecordIconMimeBodyPartFunction.class);
    private final MimeBodyPartRecorder mimeBodyPartRecorder;
    private final ConfluenceWebItemModuleDescriptor confluenceDescriptor;
    private final EmbeddedResourceParamRecordingPredicate recordingPredicate;

    RecordIconMimeBodyPartFunction(MimeBodyPartRecorder mimeBodyPartRecorder, ConfluenceWebItemModuleDescriptor webItemModuleDescriptor) {
        this.mimeBodyPartRecorder = mimeBodyPartRecorder;
        this.confluenceDescriptor = webItemModuleDescriptor;
        this.recordingPredicate = new EmbeddedResourceParamRecordingPredicate();
    }

    @Override
    public Iterable<Pair<Icon, Optional<MimeBodyPartReference>>> apply(@NonNull DataSourceFactory dataSourceFactory) {
        Iterable<DataSource> resources = dataSourceFactory.getResourcesFromModules(new ModuleCompleteKey(this.confluenceDescriptor.getCompleteKey()), this.recordingPredicate);
        return new ConvertToIconReferencePairFunction().apply(resources);
    }

    private Pair<Icon, Optional<MimeBodyPartReference>> extractIconReference(DataSource dataSource) {
        Optional<MimeBodyPartReference> mimeBodyPartReference = this.mimeBodyPartRecorder.trackSource(dataSource);
        Map<String, String> parameters = this.recordingPredicate.getParametersForResource(dataSource.getName());
        Icon icon = RecordIconMimeBodyPartFunction.makeIconForEmbedding(mimeBodyPartReference.orElseThrow().getLocator(), dataSource.getName(), parameters);
        return Pair.pair((Object)icon, mimeBodyPartReference);
    }

    private static Icon makeIconForEmbedding(URI iconSid, String resourceName, Map<String, String> resourceParams) {
        int height;
        int width;
        try {
            String widthParam = resourceParams.get("width");
            String heightParam = resourceParams.get("height");
            width = Integer.parseInt(widthParam == null ? "16" : widthParam, 10);
            height = Integer.parseInt(heightParam == null ? "16" : heightParam, 10);
        }
        catch (NumberFormatException e) {
            if (ConfluenceSystemProperties.isDevMode()) {
                throw new IllegalArgumentException(resourceName + " : width or height of the resource descriptor parameter needs to be a number. Using default of 16x16", e);
            }
            log.warn("{} : width or height of the resource descriptor parameter needs to be a number. Using default of 16x16", (Object)resourceName);
            width = 16;
            height = 16;
        }
        return new Icon(iconSid.toASCIIString(), width, height, false);
    }

    private class ConvertToIconReferencePairFunction
    implements Function<Iterable<DataSource>, Iterable<Pair<Icon, Optional<MimeBodyPartReference>>>> {
        private ConvertToIconReferencePairFunction() {
        }

        @Override
        public Iterable<Pair<Icon, Optional<MimeBodyPartReference>>> apply(Iterable<DataSource> dataSources) {
            return StreamSupport.stream(dataSources.spliterator(), false).map(RecordIconMimeBodyPartFunction.this::extractIconReference).collect(Collectors.toList());
        }
    }
}

