/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.service;

import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.confluence.api.model.web.WebItemView;
import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.mail.embed.MimeBodyPartDataSource;
import com.atlassian.confluence.mail.embed.MimeBodyPartRecorder;
import com.atlassian.confluence.mail.embed.MimeBodyPartReference;
import com.atlassian.confluence.plugin.descriptor.web.descriptors.ConfluenceWebItemModuleDescriptor;
import com.atlassian.confluence.plugin.descriptor.web.model.ConfluenceWebIcon;
import com.atlassian.confluence.web.service.RecordIconMimeBodyPartFunction;
import com.atlassian.confluence.web.service.WebViewServiceImpl;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Pair;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebItemModuleDescriptorToWebItemViewTransformer
implements Function<WebItemModuleDescriptor, WebItemView> {
    private static final Logger log = LoggerFactory.getLogger(WebItemModuleDescriptorToWebItemViewTransformer.class);
    private static final String ICON_SUFFIX = MimeBodyPartDataSource.encode(":icon");
    private final Map<String, Object> webContext;
    private final HttpServletRequest request;
    private final MimeBodyPartRecorder mimeBodyPartRecorder;
    private final DataSourceFactory dataSourceFactory;
    private final DynamicWebInterfaceManager webInterfaceManager;

    public WebItemModuleDescriptorToWebItemViewTransformer(Map<String, Object> webContext, HttpServletRequest request, MimeBodyPartRecorder mimeBodyPartRecorder, DataSourceFactory dataSourceFactory, DynamicWebInterfaceManager webInterfaceManager) {
        this.webContext = webContext;
        this.request = request;
        this.mimeBodyPartRecorder = mimeBodyPartRecorder;
        this.dataSourceFactory = dataSourceFactory;
        this.webInterfaceManager = webInterfaceManager;
    }

    @Override
    public WebItemView apply(WebItemModuleDescriptor descriptor) {
        try {
            ConfluenceWebItemModuleDescriptor confluenceDescriptor = (ConfluenceWebItemModuleDescriptor)descriptor;
            String url = confluenceDescriptor.getLink().getDisplayableUrl(this.request, this.webContext);
            String urlWithoutContextPath = confluenceDescriptor.getLink().getRenderedUrl(this.webContext);
            String accessKey = confluenceDescriptor.getLink().getAccessKey(new HashMap<String, Object>(this.webContext));
            String label = confluenceDescriptor.getLabel().getDisplayableLabel(this.request, this.webContext);
            WebItemView.Builder builder = WebItemView.builder().setId(confluenceDescriptor.getLink().getId()).setModuleKey(descriptor.getKey()).setCompleteKey(descriptor.getCompleteKey()).setSection(descriptor.getSection()).setAccessKey(accessKey).setStyleClass(confluenceDescriptor.getStyleClass()).setUrlWithoutContextPath(urlWithoutContextPath);
            if (confluenceDescriptor.getTooltip() != null) {
                builder.setTooltip(confluenceDescriptor.getTooltip().getDisplayableLabel(this.request, this.webContext));
            }
            builder.setIcon(this.buildIcon(confluenceDescriptor, this.request));
            Map<String, String> params = this.getParams(descriptor);
            if (!params.isEmpty()) {
                builder.setParams(params);
            }
            return builder.create(descriptor.getKey(), url, label, confluenceDescriptor.getWeight());
        }
        catch (RuntimeException e) {
            if (WebViewServiceImpl.failFast) {
                throw e;
            }
            log.warn("Transformation of [{}] to an instance of [{}] failed. The input will be filtered from the results, see trace for cause.", (Object)descriptor, (Object)WebItemView.class.getName());
            return null;
        }
    }

    private Optional<Icon> buildIcon(ConfluenceWebItemModuleDescriptor confluenceDescriptor, HttpServletRequest request) {
        ConfluenceWebIcon webIcon = confluenceDescriptor.getIcon();
        if (webIcon == null) {
            return Optional.empty();
        }
        if (!this.mimeBodyPartRecorder.isRecording()) {
            String url = webIcon.getUrl().getDisplayableUrl(request, this.webContext);
            return Optional.of(new Icon(url, webIcon.getHeight(), webIcon.getWidth(), false));
        }
        RecordIconMimeBodyPartFunction bodyParter = new RecordIconMimeBodyPartFunction(this.mimeBodyPartRecorder, confluenceDescriptor);
        for (Pair<Icon, Optional<MimeBodyPartReference>> p : bodyParter.apply(this.dataSourceFactory)) {
            if (!((MimeBodyPartReference)((Optional)p.right()).orElseThrow()).getDataSource().getName().endsWith(ICON_SUFFIX)) continue;
            return Optional.of((Icon)p.left());
        }
        return Optional.empty();
    }

    private Map<String, String> getParams(WebItemModuleDescriptor descriptor) {
        HashMap<String, Object> context = new HashMap<String, Object>(this.webContext);
        if (descriptor.getContextProvider() != null) {
            context.putAll(descriptor.getContextProvider().getContextMap(context));
        }
        return Maps.transformValues((Map)descriptor.getParams(), value -> this.webInterfaceManager.getWebFragmentHelper().renderVelocityFragment(value, (Map)context));
    }
}

