/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.service;

import com.atlassian.confluence.api.model.web.WebPanelView;
import com.atlassian.confluence.web.service.WebViewServiceImpl;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebPanelModuleDescriptorToWebPanelView
implements Function<WebPanelModuleDescriptor, WebPanelView> {
    private static final Logger log = LoggerFactory.getLogger(WebPanelModuleDescriptorToWebPanelView.class);
    private final HttpServletRequest request;
    private final Map<String, Object> webContext;

    WebPanelModuleDescriptorToWebPanelView(HttpServletRequest request, Map<String, Object> webContext) {
        this.request = request;
        this.webContext = webContext;
    }

    @Override
    public WebPanelView apply(WebPanelModuleDescriptor moduleDescriptor) {
        try {
            String renderedPanel = ((WebPanel)moduleDescriptor.getModule()).getHtml(this.webContext);
            WebPanelView.Builder panelBuilder = new WebPanelView.Builder();
            String label = moduleDescriptor.getWebLabel() != null ? moduleDescriptor.getWebLabel().getDisplayableLabel(this.request, this.webContext) : null;
            return panelBuilder.setModuleKey(moduleDescriptor.getKey()).setCompleteKey(moduleDescriptor.getCompleteKey()).setLabel(label).setWeight(moduleDescriptor.getWeight()).setName(moduleDescriptor.getName()).setLocation(moduleDescriptor.getLocation()).create(renderedPanel);
        }
        catch (RuntimeException e) {
            if (WebViewServiceImpl.failFast) {
                throw e;
            }
            log.warn("Transformation of [{}] to an instance of [{}] failed. The moduleDescriptor will be filtered from the results, see trace for cause.", (Object)moduleDescriptor, (Object)WebPanelView.class.getName());
            return null;
        }
    }
}

