/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.web.service;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.web.WebItemView;
import com.atlassian.confluence.api.model.web.WebPanelView;
import com.atlassian.confluence.api.model.web.WebSectionView;
import com.atlassian.confluence.api.service.web.WebView;
import com.atlassian.confluence.api.service.web.WebViewService;
import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.mail.embed.MimeBodyPartRecorder;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.web.WebMenuManager;
import com.atlassian.confluence.web.WebMenuSection;
import com.atlassian.confluence.web.service.FakeRequestFactory;
import com.atlassian.confluence.web.service.WebContextFactory;
import com.atlassian.confluence.web.service.WebItemModuleDescriptorToWebItemViewTransformer;
import com.atlassian.confluence.web.service.WebPanelModuleDescriptorToWebPanelView;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebViewServiceImpl
implements WebViewService {
    private static final Logger log = LoggerFactory.getLogger(WebViewServiceImpl.class);
    static final boolean failFast = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode"));
    private final DynamicWebInterfaceManager webInterfaceManager;
    private final WebMenuManager webMenuManager;
    private final WebContextFactory webContextFactory;
    private final MimeBodyPartRecorder mimeBodyPartRecorder;
    private final DataSourceFactory dataSourceFactory;
    private final FakeRequestFactory fakeRequestFactory;
    private final Map<String, List<String>> webItemBlacklist;

    WebViewServiceImpl(DynamicWebInterfaceManager webInterfaceManager, WebMenuManager webMenuManager, WebContextFactory webContextFactory, MimeBodyPartRecorder mimeBodyPartRecorder, DataSourceFactory dataSourceFactory, ContextPathHolder contextPathHolder, Map<String, List<String>> webItemBlacklist) {
        this.webInterfaceManager = webInterfaceManager;
        this.webMenuManager = webMenuManager;
        this.webContextFactory = webContextFactory;
        this.mimeBodyPartRecorder = mimeBodyPartRecorder;
        this.dataSourceFactory = dataSourceFactory;
        this.fakeRequestFactory = new FakeRequestFactory(contextPathHolder);
        this.webItemBlacklist = ImmutableMap.copyOf(webItemBlacklist);
    }

    public WebView forContent(String contentId) {
        WebInterfaceContext webInterfaceContext = this.webContextFactory.createWebInterfaceContext(contentId != null ? Long.valueOf(contentId) : null);
        return this.forContext(webInterfaceContext);
    }

    public WebView forContent(ContentId contentId) {
        return this.forContent(contentId, (Map<String, Object>)ImmutableMap.of());
    }

    public WebView forContent(@Nullable ContentId contentId, Map<String, Object> additionalContext) {
        Long id = contentId != null ? Long.valueOf(contentId.asLong()) : null;
        WebInterfaceContext webInterfaceContext = this.webContextFactory.createWebInterfaceContext(id, additionalContext);
        return this.forContext(webInterfaceContext);
    }

    public WebView forGeneric() {
        return this.forContent((ContentId)null);
    }

    public WebView forSpace(String spaceKey) {
        WebInterfaceContext webInterfaceContext = this.webContextFactory.createWebInterfaceContextForSpace(spaceKey);
        return this.forContext(webInterfaceContext);
    }

    private WebView forContext(final WebInterfaceContext webInterfaceContext) {
        return new WebView(){

            public Iterable<WebItemView> getItemsForSection(String section, Map<String, Object> additionalContext) {
                return WebViewServiceImpl.this.transformWebItems(WebViewServiceImpl.this.webInterfaceManager.getDisplayableItems(section, WebViewServiceImpl.joinWebInterfaceAndAdditionalContext(webInterfaceContext, additionalContext).toMap()), WebViewServiceImpl.this.webContextFactory.createWebItemTemplateContext(webInterfaceContext, additionalContext));
            }

            public Iterable<WebSectionView> getSectionsForLocation(String location, Map<String, Object> additionalContext) {
                return this.getSectionsForLocations(Collections.singleton(location), additionalContext);
            }

            public Iterable<WebSectionView> getSectionsForLocations(Collection<String> locations, Map<String, Object> additionalContext) {
                return WebViewServiceImpl.this.transformWebSections(WebViewServiceImpl.this.webMenuManager.getMenu(locations, WebViewServiceImpl.joinWebInterfaceAndAdditionalContext(webInterfaceContext, additionalContext)).getSections(), WebViewServiceImpl.this.webContextFactory.createTemplateContext(webInterfaceContext, additionalContext));
            }

            public Iterable<WebPanelView> getPanelsForLocation(String location, Map<String, Object> additionalContext) {
                Map<String, Object> context = WebViewServiceImpl.this.webContextFactory.createWebPanelTemplateContext(webInterfaceContext, additionalContext);
                return WebViewServiceImpl.this.transformWebPanels(WebViewServiceImpl.this.webInterfaceManager.getDisplayableWebPanelDescriptors(location, context), context);
            }

            public Iterable<WebPanelView> getPanelsForLocations(Collection<String> locations, Map<String, Object> additionalContext) {
                return locations.stream().flatMap(location -> StreamSupport.stream(this.getPanelsForLocation((String)location, additionalContext).spliterator(), false)).collect(Collectors.toList());
            }

            public Map<String, Object> getWebPanelVelocityContext() {
                return WebViewServiceImpl.this.webContextFactory.createWebPanelTemplateContext(webInterfaceContext, null);
            }
        };
    }

    private static WebInterfaceContext joinWebInterfaceAndAdditionalContext(WebInterfaceContext webInterfaceContext, Map<String, Object> additionalContext) {
        if (additionalContext == null || additionalContext.isEmpty()) {
            return webInterfaceContext;
        }
        DefaultWebInterfaceContext joined = DefaultWebInterfaceContext.copyOf(webInterfaceContext);
        joined.setParameters(additionalContext);
        return joined;
    }

    private Iterable<WebItemView> transformWebItems(List<? extends WebItemModuleDescriptor> displayableItems, Map<String, Object> webItemContextSupplier) {
        return displayableItems.stream().filter(new NotBlacklisted()).map(new WebItemModuleDescriptorToWebItemViewTransformer(webItemContextSupplier, this.getRequestForRendering(), this.mimeBodyPartRecorder, this.dataSourceFactory, this.webInterfaceManager)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Iterable<WebSectionView> transformWebSections(List<WebMenuSection> sections, Map<String, Object> webContextSupplier) {
        return sections.stream().map(new WebMenuSectionToWebSectionViewTransformer(webContextSupplier)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Iterable<WebPanelView> transformWebPanels(List<? extends com.atlassian.plugin.web.api.descriptors.WebPanelModuleDescriptor> displayablePanels, Map<String, Object> webContextSupplier) {
        return displayablePanels.stream().map(panel -> (WebPanelModuleDescriptor)panel).map(new WebPanelModuleDescriptorToWebPanelView(this.getRequestForRendering(), webContextSupplier)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private HttpServletRequest getRequestForRendering() {
        return this.fakeRequestFactory.createFakeRequestUnlessNonNull(ServletContextThreadLocal.getRequest());
    }

    private class NotBlacklisted
    implements Predicate<WebItemModuleDescriptor> {
        private NotBlacklisted() {
        }

        @Override
        public boolean test(@NonNull WebItemModuleDescriptor input) {
            List<String> blacklistedSection = WebViewServiceImpl.this.webItemBlacklist.get(input.getSection());
            if (blacklistedSection != null && blacklistedSection.contains(input.getKey())) {
                log.debug("WebItem [{}] is blacklisted.", (Object)input);
                return false;
            }
            return true;
        }
    }

    private class WebMenuSectionToWebSectionViewTransformer
    implements Function<WebMenuSection, WebSectionView> {
        private final Map<String, Object> webContext;

        public WebMenuSectionToWebSectionViewTransformer(Map<String, Object> webContext) {
            this.webContext = webContext;
        }

        @Override
        public WebSectionView apply(WebMenuSection input) {
            try {
                WebSectionView.Builder sectionBuilder = new WebSectionView.Builder();
                sectionBuilder.addItems(WebViewServiceImpl.this.transformWebItems(input.getItems(), this.webContext));
                sectionBuilder.setStyleClass(input.getClassName());
                return sectionBuilder.create(input.getId(), input.getLabel());
            }
            catch (RuntimeException e) {
                if (failFast) {
                    throw e;
                }
                log.debug("Construction of [{}] using given [{}] failed. The input will be filtered from the results, see trace for cause.", (Object)WebSectionView.class.getName(), (Object)input);
                log.trace(e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }
}

