/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.keyboardshortcuts;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/")
public class ShortcutSettingsResource {
    private final UserAccessor userAccessor;

    @Inject
    public ShortcutSettingsResource(@ComponentImport UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @GET
    @Path(value="enabled")
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getShortcutsEnabled() {
        UserPreferences userPreferences = this.getUserPreferences();
        Boolean shortcutsDisabled = userPreferences.getBoolean("confluence.user.keyboard.shortcuts.disabled").orElse(false);
        return Response.ok((Object)Boolean.valueOf(shortcutsDisabled == false).toString()).build();
    }

    @POST
    @Path(value="enabled")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response setShortcutsEnabled(State state) {
        UserPreferences userPreferences = this.getUserPreferences();
        try {
            userPreferences.setBoolean("confluence.user.keyboard.shortcuts.disabled", !state.enabled);
        }
        catch (UserPreferences.PreferenceException e) {
            return Response.serverError().build();
        }
        return Response.ok((Object)String.valueOf(state.enabled)).build();
    }

    private UserPreferences getUserPreferences() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return null;
        }
        return this.userAccessor.getUserPreferences(user);
    }

    public static class State {
        @JsonProperty
        private boolean enabled;
    }
}

