/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.providers.confluence;

import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentTypeAware;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.util.GlobalIdFactory;
import com.atlassian.user.User;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;

public class FieldHelper {
    static final String APP_CONFLUENCE = FieldHelper.class.getPackage().getName();
    private final HostApplication hostApplication;
    private final UserAccessor userAccessor;

    public FieldHelper(HostApplication hostApplication, UserAccessor userAccessor) {
        this.hostApplication = hostApplication;
        this.userAccessor = userAccessor;
    }

    public NotificationBuilder buildNotification(ContentEntityObject content) {
        return this.buildNotification(content, (User)this.getUser().getOrNull());
    }

    public NotificationBuilder buildNotification(ContentEntityObject content, User fromUser) {
        String url = content.getUrlPath();
        String gravatarUrl = this.createGravatarUrl(fromUser);
        return new NotificationBuilder().applicationLinkId(this.hostApplication.getId().get()).globalId(this.createGlobalId(FieldHelper.getContentType(content), content.getId())).application(APP_CONFLUENCE).entity(FieldHelper.getContentType(content)).itemTitle(content.getDisplayTitle()).iconUrl(gravatarUrl).itemUrl(url).url(url);
    }

    public String createGravatarUrl(User user) {
        return this.userAccessor.getUserProfilePicture(user).getDownloadPath();
    }

    public static String getContentTypeDescription(ContentEntityObject content) {
        return switch (ContentTypeEnum.forEntity((ContentTypeAware)content)) {
            case ContentTypeEnum.COMMENT -> "a comment";
            case ContentTypeEnum.BLOG -> "a blog post";
            default -> "a page";
        };
    }

    public static String getContentType(ContentEntityObject content) {
        return switch (ContentTypeEnum.forEntity((ContentTypeAware)content)) {
            case ContentTypeEnum.COMMENT -> "comment";
            case ContentTypeEnum.BLOG -> "blog";
            default -> "page";
        };
    }

    public String getHostId() {
        return this.hostApplication.getId().get();
    }

    public Option<ConfluenceUser> getUser() {
        return Option.option((Object)AuthenticatedUserThreadLocal.get());
    }

    String createGlobalId(String entity, Long id) {
        return GlobalIdFactory.encode(List.of("appId", "entity", "id"), Map.of("appId", this.hostApplication.getId().get(), "entity", entity, "id", id.toString()));
    }
}

