/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.BaseServletModuleDescriptor;
import com.atlassian.plugin.servlet.filter.FilterDispatcherCondition;
import com.atlassian.plugin.servlet.filter.FilterLocation;
import com.atlassian.plugin.util.validation.ValidationException;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.ResettableLazyReference;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ServletFilterModuleDescriptor
extends BaseServletModuleDescriptor<Filter>
implements StateAware {
    @VisibleForTesting
    static final String ASYNC_DEFAULT_SYSPROP = "atlassian.plugins.filter.async.default";
    @VisibleForTesting
    static final ResettableLazyReference<Boolean> ASYNC_DEFAULT = new ResettableLazyReference<Boolean>(){

        protected Boolean create() {
            return Boolean.getBoolean(ServletFilterModuleDescriptor.ASYNC_DEFAULT_SYSPROP);
        }
    };
    @VisibleForTesting
    static final String FORCE_ASYNC_DISPATCHER_SYSPROP = "atlassian.plugins.filter.force.async.dispatcher";
    @VisibleForTesting
    static final ResettableLazyReference<Boolean> FORCE_ASYNC = new ResettableLazyReference<Boolean>(){

        protected Boolean create() {
            return Boolean.getBoolean(ServletFilterModuleDescriptor.FORCE_ASYNC_DISPATCHER_SYSPROP);
        }
    };
    static final String DEFAULT_LOCATION = FilterLocation.BEFORE_DISPATCH.name();
    static final String DEFAULT_WEIGHT = "100";
    private final Set<DispatcherType> dispatcherTypes = EnumSet.of(DispatcherType.REQUEST);
    private final ServletModuleManager servletModuleManager;
    private FilterLocation location;
    private int weight;
    private static final String DISPATCHER = "dispatcher";
    public static final Comparator<ServletFilterModuleDescriptor> byWeight = Comparator.comparingInt(ServletFilterModuleDescriptor::getWeight);

    public ServletFilterModuleDescriptor(ModuleFactory moduleFactory, ServletModuleManager servletModuleManager) {
        super(moduleFactory);
        this.servletModuleManager = Objects.requireNonNull(servletModuleManager, "servletModuleManager");
    }

    @Override
    public void init(@Nonnull Plugin plugin, @Nonnull Element element) {
        super.init(plugin, element);
        try {
            this.location = FilterLocation.parse(element.attributeValue("location", DEFAULT_LOCATION));
            this.weight = Integer.parseInt(element.attributeValue("weight", DEFAULT_WEIGHT));
        }
        catch (IllegalArgumentException ex) {
            throw new PluginParseException((Throwable)ex);
        }
        List dispatcherElements = element.elements(DISPATCHER);
        if (!dispatcherElements.isEmpty()) {
            this.dispatcherTypes.clear();
            for (Element dispatcher : dispatcherElements) {
                this.dispatcherTypes.add(DispatcherType.valueOf((String)dispatcher.getTextTrim()));
            }
        }
        if (((Boolean)FORCE_ASYNC.get()).booleanValue()) {
            this.dispatcherTypes.add(DispatcherType.ASYNC);
        }
    }

    @Override
    protected void validate(Element element) {
        super.validate(element);
        List dispatcherElements = element.elements(DISPATCHER);
        if (!dispatcherElements.isEmpty()) {
            for (Element dispatcherElement : dispatcherElements) {
                if (this.isKnownDispatcherType(dispatcherElement.getTextTrim())) continue;
                throw new ValidationException("There were validation errors:", Collections.singletonList("The dispatcher value must be one of the following only " + String.valueOf(Arrays.asList(DispatcherType.values()))));
            }
        }
        if (element.attributeValue("class") == null) {
            throw new ValidationException("There were validation errors:", Collections.singletonList("The class is required"));
        }
    }

    private boolean isKnownDispatcherType(String type) {
        for (DispatcherType dispatcherType : DispatcherType.values()) {
            if (!dispatcherType.toString().equals(type)) continue;
            return true;
        }
        return false;
    }

    public void enabled() {
        super.enabled();
        this.servletModuleManager.addFilterModule(this);
    }

    public void disabled() {
        this.servletModuleManager.removeFilterModule(this);
        super.disabled();
    }

    public Filter getModule() {
        return (Filter)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    public FilterLocation getLocation() {
        return this.location;
    }

    public int getWeight() {
        return this.weight;
    }

    @Deprecated
    public Set<FilterDispatcherCondition> getDispatcherConditions() {
        return this.dispatcherTypes.stream().map(FilterDispatcherCondition::fromDispatcherType).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<DispatcherType> getDispatcherTypes() {
        return this.dispatcherTypes;
    }

    @Override
    protected boolean getDefaultAsyncSupported() {
        return (Boolean)ASYNC_DEFAULT.get();
    }
}

