/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.labels.actions;

import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.content.service.SpaceService;
import com.atlassian.confluence.dmz.labels.LabelManagerInternal;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelPermissionEnforcer;
import com.atlassian.confluence.labels.dto.LiteLabelSearchResult;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.beans.SuggestedLabels;
import com.atlassian.confluence.search.actions.json.ContentNameMatch;
import com.atlassian.confluence.search.actions.json.ContentNameSearchResult;
import com.atlassian.confluence.search.contentnames.QueryToken;
import com.atlassian.confluence.search.contentnames.QueryTokenizer;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LabelSuggestionService {
    private static final Collator collator = Collator.getInstance();
    private static final QueryTokenizer tokenizer = query1 -> {
        ArrayList<QueryToken> result = new ArrayList<QueryToken>();
        result.add(new QueryToken(query1, QueryToken.Type.FULL));
        for (String q : query1.split("[\\s,]")) {
            result.add(new QueryToken(q, QueryToken.Type.PARTIAL));
        }
        return result;
    };
    protected static final String PAGE_NOT_EXIST = "The page specified does not exist";
    protected static final String CONTENT_SPACE_MISMATCH = "Specified contentId does not match spaceKey";
    protected static final String SPACE_NOT_EXIST = "The space specified or the space to which the specified page belongs, does not exist or cannot be accessed";
    private final int MAX_CONTENT_BY_LABELS_TO_PROCESS = Integer.getInteger("confluence.content.by.label.suggest.labels.max.to.process", 10000);
    private final LabelManagerInternal labelManager;
    private final PageManager pageManager;
    private final SpaceService spaceService;
    private final PermissionManager permissionManager;
    private final PaginationService paginationService;
    private final LabelPermissionEnforcer labelPermissionEnforcer;

    public LabelSuggestionService(LabelManagerInternal labelManager, PageManager pageManager, SpaceService spaceService, PermissionManager permissionManager, PaginationService paginationService, LabelPermissionEnforcer labelPermissionEnforcer) {
        this.labelManager = labelManager;
        this.pageManager = pageManager;
        this.spaceService = spaceService;
        this.permissionManager = permissionManager;
        this.paginationService = paginationService;
        this.labelPermissionEnforcer = labelPermissionEnforcer;
    }

    public ContentNameSearchResult findSuggestedLabels(String query, boolean isTeamLabel, int maxResults, String spaceKey, boolean ignoreRelated, long contentId) {
        Space space;
        AbstractPage page = this.pageManager.getAbstractPage(contentId);
        if (contentId != 0L) {
            if (page == null || !this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)page)) {
                throw new BadRequestException(PAGE_NOT_EXIST);
            }
            if (spaceKey != null && !Objects.equals(spaceKey, page.getSpaceKey())) {
                throw new BadRequestException(CONTENT_SPACE_MISMATCH);
            }
            if (spaceKey == null) {
                spaceKey = page.getSpaceKey();
            }
        }
        if (!(spaceKey == null || (space = this.spaceService.getKeySpaceLocator(spaceKey).getSpace()) != null && this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)space))) {
            throw new BadRequestException(SPACE_NOT_EXIST);
        }
        if (maxResults <= 0 || maxResults > 50) {
            maxResults = 50;
        }
        return this.findSuggestedLabels(query.trim().toLowerCase(), isTeamLabel, maxResults, spaceKey, ignoreRelated, page);
    }

    ContentNameSearchResult findSuggestedLabels(String query, boolean isTeamLabel, int maxResults, String spaceKey, boolean ignoreRelated, AbstractPage page) {
        int missing;
        ContentNameSearchResult result = new ContentNameSearchResult(query);
        List queryTokens = tokenizer.tokenize(query);
        result.setQueryTokens(queryTokens);
        HashSet<LiteLabelSearchResult> suggestedLabels = new HashSet();
        if (!ignoreRelated) {
            suggestedLabels = this.getSuggestedLabels(queryTokens, page, maxResults, spaceKey);
            result.addMatchGroup(this.convertToContentNameMatchList(this.sortLabels(suggestedLabels)));
        }
        if ((missing = maxResults - suggestedLabels.size()) > 0 && queryTokens.size() == 2) {
            String prefix = ((QueryToken)queryTokens.get(0)).getText();
            Set<LiteLabelSearchResult> otherLabels = this.getLabelsStartingWithPrefix(prefix, missing, isTeamLabel);
            suggestedLabels.forEach(otherLabels::remove);
            if (!otherLabels.isEmpty()) {
                result.addMatchGroup(this.convertToContentNameMatchList(otherLabels));
            }
        }
        return result;
    }

    private Set<LiteLabelSearchResult> getLabelsStartingWithPrefix(String prefix, int limit, boolean isTeamLabel) {
        SimplePageRequest pageRequest = new SimplePageRequest(0, limit);
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)this.MAX_CONTENT_BY_LABELS_TO_PROCESS);
        List labels = this.paginationService.performPaginationListRequest(limitedRequest, arg_0 -> this.lambda$getLabelsStartingWithPrefix$1(isTeamLabel, prefix, (PageRequest)pageRequest, arg_0), Function.identity()).getResults();
        return labels.stream().map(LiteLabelSearchResult::new).collect(Collectors.toSet());
    }

    private PageResponse<Label> getAuthorizedLabelsStartingWithPrefix(PageRequest pageRequest, LimitedRequest paginationRequest, PageResponse<Label> result) {
        List authorizedLabels = this.labelPermissionEnforcer.filterAuthorizedLabels(result.getResults());
        return PageResponseImpl.builder().addAll((Iterable)authorizedLabels).hasMore(paginationRequest.getStart() + paginationRequest.getLimit() < this.MAX_CONTENT_BY_LABELS_TO_PROCESS && result.hasMore()).pageRequest(pageRequest).build();
    }

    private Set<LiteLabelSearchResult> getSuggestedLabels(List<QueryToken> queryTokens, AbstractPage entity, int maxResults, String spaceKey) {
        List<String> partialTokenStrings = this.getPartialTokenStrings(queryTokens);
        Set tokenExactMatchLabels = this.labelManager.getLabels(partialTokenStrings).stream().map(LiteLabelSearchResult::new).collect(Collectors.toSet());
        int limit = maxResults + (entity != null ? entity.getLabelCount() : 0);
        Set recentAndPopularLabels = new SuggestedLabels((LabelManager)this.labelManager).getSuggestedLiteLabels(entity != null ? entity.getSpaceKey() : spaceKey, (User)AuthenticatedUserThreadLocal.get(), limit);
        HashSet<LiteLabelSearchResult> suggestedLabels = new HashSet<LiteLabelSearchResult>();
        suggestedLabels.addAll(tokenExactMatchLabels);
        suggestedLabels.addAll(recentAndPopularLabels);
        return this.filterLabelsByQuery(suggestedLabels, queryTokens, maxResults);
    }

    private List<LiteLabelSearchResult> sortLabels(Set<LiteLabelSearchResult> labels) {
        ArrayList<LiteLabelSearchResult> labelList = new ArrayList<LiteLabelSearchResult>(labels);
        labelList.sort((o1, o2) -> collator.compare(o1.getName(), o2.getName()));
        return labelList;
    }

    private List<String> getPartialTokenStrings(List<QueryToken> queryTokens) {
        return queryTokens.stream().filter(input -> input.getType() == QueryToken.Type.PARTIAL).map(QueryToken::getText).collect(Collectors.toList());
    }

    private List<ContentNameMatch> convertToContentNameMatchList(Collection<LiteLabelSearchResult> labels) {
        return labels.stream().map(label -> new ContentNameMatch("label-suggestion", label.getName(), label.getUrlPath())).collect(Collectors.toList());
    }

    private Set<LiteLabelSearchResult> filterLabelsByQuery(Set<LiteLabelSearchResult> suggestedLabels, List<QueryToken> queryTokens, int maxResults) {
        HashSet<LiteLabelSearchResult> labels = new HashSet<LiteLabelSearchResult>();
        block0: for (LiteLabelSearchResult label : suggestedLabels) {
            if (labels.size() >= maxResults) break;
            for (QueryToken t : queryTokens) {
                if (!label.getName().startsWith(t.getText())) continue;
                labels.add(label);
                continue block0;
            }
        }
        return labels;
    }

    private /* synthetic */ PageResponse lambda$getLabelsStartingWithPrefix$1(boolean isTeamLabel, String prefix, PageRequest pageRequest, LimitedRequest paginationRequest) {
        PageResponse result = isTeamLabel ? this.labelManager.findTeamLabelsByNamePrefix(prefix, paginationRequest) : this.labelManager.findGlobalLabelsByNamePrefix(prefix, paginationRequest);
        return this.getAuthorizedLabelsStartingWithPrefix(pageRequest, paginationRequest, (PageResponse<Label>)result);
    }
}

