/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.labels.actions;

import com.atlassian.confluence.event.Evented;
import com.atlassian.confluence.event.events.label.LabelListViewEvent;
import com.atlassian.confluence.labels.actions.RankedNameComparator;
import com.atlassian.confluence.labels.actions.RankedRankComparator;
import com.atlassian.confluence.labels.persistence.dao.LabelSearchResult;
import com.atlassian.confluence.labels.persistence.dao.RankedLabelSearchResult;
import com.atlassian.confluence.plugins.labels.actions.AbstractLabelDisplayingAction;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.struts2.ActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class RankListLabelsAction
extends AbstractLabelDisplayingAction
implements Evented<LabelListViewEvent> {
    private List<LabelSearchResult> mostPopularLabels;
    private Set<RankedLabelSearchResult> results;

    @StrutsParameter
    public void setGroupRanks(boolean b) {
        ActionContext.getContext().getSession().put("confluence.labels.heatmap.group.ranks", b);
    }

    public boolean isGroupRanks() {
        Boolean groupRanks = (Boolean)ActionContext.getContext().getSession().get("confluence.labels.heatmap.group.ranks");
        return groupRanks != null && groupRanks != false;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        Object comp = this.isGroupRanks() ? new RankedRankComparator() : new RankedNameComparator();
        this.results = this.space != null ? this.labelManager.getMostPopularLabelsWithRanksInSpace(this.space.getKey(), 200, (Comparator)comp) : this.labelManager.getMostPopularLabelsWithRanks(200, (Comparator)comp);
        return "success";
    }

    public LabelListViewEvent getEventToPublish(String result) {
        return new LabelListViewEvent((Object)this, this.getSpace(), "heatmap");
    }

    public Set<RankedLabelSearchResult> getResults() {
        return this.results;
    }

    public List<LabelSearchResult> getMostPopularLabels() {
        if (this.mostPopularLabels == null) {
            this.mostPopularLabels = this.space != null ? this.labelManager.getMostPopularLabelsInSpace(this.space.getKey(), 200) : this.labelManager.getMostPopularLabels(200);
        }
        return this.mostPopularLabels;
    }
}

