/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.labels.rest;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.internal.api.security.ConfluenceScopesRequestCache;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.plugins.labels.actions.LabelSuggestionService;
import com.atlassian.confluence.search.actions.json.ContentNameSearchResult;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/")
public class LabelResource {
    protected static final String EMPTY_QUERY = "Cannot autocomplete labels for empty query";
    private final LabelSuggestionService labelSuggestionService;
    private final ConfluenceScopesRequestCache scopesRequestCacheDelegate;
    private final UserAccessor userAccessor;

    @Inject
    public LabelResource(LabelSuggestionService labelSuggestionService, ConfluenceScopesRequestCache confluenceScopesRequestCache, UserAccessor userAccessor) {
        this.labelSuggestionService = labelSuggestionService;
        this.scopesRequestCacheDelegate = confluenceScopesRequestCache;
        this.userAccessor = userAccessor;
    }

    @GET
    @Path(value="/autocomplete")
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @AnonymousSiteAccess
    @ScopesAllowed(requiredScope={"READ", "JSM_KB"})
    public Response autocompleteLabel(@QueryParam(value="query") String query, @QueryParam(value="contentId") long contentId, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="ignoreRelated") boolean ignoreRelated, @QueryParam(value="isTeamLabel") boolean isTeamLabel, @QueryParam(value="xoauth_requestor_id") String username) {
        if (this.scopesRequestCacheDelegate != null && this.scopesRequestCacheDelegate.isScopePermitted("JSM_KB") && username != null) {
            AuthenticatedUserThreadLocal.setUser((User)this.userAccessor.getUser(username));
        }
        this.validateLabel(query);
        ContentNameSearchResult result = this.labelSuggestionService.findSuggestedLabels(query, isTeamLabel, maxResults, spaceKey, ignoreRelated, contentId);
        return Response.ok((Object)result).build();
    }

    private void validateLabel(String labelName) {
        if (StringUtils.isEmpty((CharSequence)labelName)) {
            throw new BadRequestException(EMPTY_QUERY);
        }
        if (!LabelParser.isValidLabelName((String)labelName)) {
            throw new BadRequestException("Invalid label name: " + labelName);
        }
    }
}

