/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.templates.actions;

import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.event.Evented;
import com.atlassian.confluence.event.events.template.TemplateListViewEvent;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.plugins.templates.actions.AbstractPageTemplateAction;
import com.atlassian.confluence.web.Cookies;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ListPageTemplatesAction
extends AbstractPageTemplateAction
implements Evented<TemplateListViewEvent> {
    private List<PageTemplate> pageTemplates;
    private List<PageTemplate> xhtmlPageTemplates;
    private static final String PLUGIN_KEY = "space-templates";

    public List<PageTemplate> getPageTemplates() {
        return this.pageTemplates;
    }

    public List<PageTemplate> getXHtmlPageTemplates() {
        return this.xhtmlPageTemplates;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        Cookies.setResponseCookie((String)"confluence.browse.space.cookie", (String)PLUGIN_KEY);
        this.pageTemplates = new ArrayList<PageTemplate>();
        this.xhtmlPageTemplates = new ArrayList<PageTemplate>();
        for (PageTemplate pageTemplate : this.getTemplatesToUse()) {
            if (StringUtils.isNotBlank((CharSequence)pageTemplate.getPluginKey())) continue;
            this.pageTemplates.add(pageTemplate);
            if (pageTemplate.getBodyType() != BodyType.XHTML) continue;
            this.xhtmlPageTemplates.add(pageTemplate);
        }
        return "success";
    }

    private List<PageTemplate> getTemplatesToUse() {
        if (this.getSpace() != null) {
            return this.getSpace().getPageTemplates();
        }
        return this.pageTemplateManager.getGlobalPageTemplates();
    }

    public TemplateListViewEvent getEventToPublish(String result) {
        return new TemplateListViewEvent((Object)this, this.getSpace());
    }
}

